/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.LinkedList;

@WebSudoRequired
@AdminOnly
public class DeleteWorkflowTransitions
extends AbstractWorkflowAction {
    private final StepDescriptor step;
    private final WorkflowService workflowService;
    private int[] transitionIds;
    private String originatingUrl;

    public DeleteWorkflowTransitions(JiraWorkflow workflow, StepDescriptor step, WorkflowService workflowService) {
        super(workflow);
        this.step = step;
        this.workflowService = workflowService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doConfirm() {
        return "confirm";
    }

    protected void doValidation() {
        if (this.transitionIds == null || this.transitionIds.length == 0) {
            this.addError("transitionIds", this.getText("admin.errors.workflows.must.select.transition"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        for (int transitionId : this.transitionIds) {
            ActionDescriptor transition = this.step.getAction(transitionId);
            if (transition == null) {
                this.addErrorMessage(this.getText("admin.errors.workflows.cannot.find.transition.with.id", "'" + transitionId + "'"));
                return "error";
            }
            this.step.getActions().remove(transition);
            if (transition.isCommon()) {
                this.step.getCommonActions().remove(new Integer(transition.getId()));
                if (this.workflow.getStepsForTransition(transition).isEmpty()) {
                    this.workflow.getDescriptor().getCommonActions().remove(new Integer(transition.getId()));
                }
            }
            if (!this.step.getActions().isEmpty() || !this.step.getCommonActions().isEmpty()) continue;
            this.step.removeActions();
        }
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.redirectToView();
    }

    private String redirectToView() {
        return this.getRedirect(this.getCancelUrl());
    }

    @Override
    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public StepDescriptor getStep() {
        return this.step;
    }

    public Collection getTransitions() {
        return this.step.getActions();
    }

    public void setTransitionIds(int[] transitionIds) {
        this.transitionIds = transitionIds;
    }

    public Collection getSelectedTransitions() {
        LinkedList<ActionDescriptor> transitions = new LinkedList<ActionDescriptor>();
        if (this.transitionIds != null) {
            for (int transitionId : this.transitionIds) {
                transitions.add(this.step.getAction(transitionId));
            }
        }
        return transitions;
    }

    public String getOriginatingUrl() {
        return this.originatingUrl;
    }

    public void setOriginatingUrl(String originatingUrl) {
        this.originatingUrl = originatingUrl;
    }

    public String getCancelUrl() {
        if ("viewWorkflowStep".equals(this.getOriginatingUrl())) {
            return "ViewWorkflowStep.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.step.getId();
        }
        return "ViewWorkflowSteps.jspa" + this.getBasicWorkflowParameters();
    }
}

