/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransition;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
@AdminOnly
public class EditWorkflowTransition
extends AbstractWorkflowTransition {
    private final ActionDescriptor action;
    private final FieldScreenManager fieldScreenManager;
    private final WorkflowActionsBean workflowActionsBean;
    private Collection fieldScreens;

    public EditWorkflowTransition(JiraWorkflow workflow, ActionDescriptor action, FieldScreenManager fieldScreenManager, WorkflowService workflowService) {
        super(workflow, workflowService);
        this.action = action;
        this.fieldScreenManager = fieldScreenManager;
        this.workflowActionsBean = new WorkflowActionsBean();
    }

    public EditWorkflowTransition(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor action, FieldScreenManager fieldScreenManager, WorkflowService workflowService) {
        super(workflow, step, workflowService);
        this.action = action;
        this.fieldScreenManager = fieldScreenManager;
        this.workflowActionsBean = new WorkflowActionsBean();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.setTransitionName(this.action.getName());
        this.setDescription((String)this.action.getMetaAttributes().get("jira.description"));
        this.setDestinationStep(this.action.getUnconditionalResult().getStep());
        FieldScreen fieldScreen = this.workflowActionsBean.getFieldScreenForView(this.action);
        this.setView(fieldScreen != null ? fieldScreen.getId().toString() : "");
        return super.doDefault();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getTransitionName())) {
            this.addError("transitionName", this.getText("admin.errors.workflows.name.must.be.specified"));
        } else if (!this.getTransitionName().equalsIgnoreCase(this.action.getName())) {
            if (this.getStep() != null) {
                this.checkDuplicateTransitionName(this.getStep().getActions(), this.getTransitionName());
            }
            if (!this.invalidInput()) {
                this.checkDuplicateTransitionName(this.getWorkflow().getDescriptor().getGlobalActions(), this.getTransitionName());
            }
        }
        if (TextUtils.stringSet((String)this.getView()) && this.getFieldScreen() == null) {
            this.addError("view", this.getText("admin.errors.workflows.invalid.screen"));
        }
        super.doValidation();
    }

    private FieldScreen getFieldScreen() {
        return this.fieldScreenManager.getFieldScreen(new Long(this.getView()));
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.action.setName(this.getTransitionName());
        this.action.getMetaAttributes().put("jira.description", this.getDescription());
        WorkflowUtil.setActionScreen((ActionDescriptor)this.action, (FieldScreen)(TextUtils.stringSet((String)this.getView()) ? this.getFieldScreen() : null));
        ResultDescriptor result = this.action.getUnconditionalResult();
        result.setStep(this.getDestinationStep());
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getRedirect(this.getCancelUrl());
    }

    public String getCancelUrl() {
        StringBuilder url = new StringBuilder("ViewWorkflowTransition.jspa").append(this.getBasicWorkflowParameters());
        if (this.getStep() != null) {
            url.append("&workflowStep=" + this.getStep().getId());
        }
        url.append("&workflowTransition=" + this.action.getId());
        return url.toString();
    }

    public ActionDescriptor getTransition() {
        return this.action;
    }

    public String isNameI8n() {
        ActionDescriptor transition = this.getTransition();
        return (String)transition.getMetaAttributes().get("jira.i18n.title");
    }

    public boolean isSetView() {
        return !this.getWorkflow().isInitialAction(this.getTransition());
    }

    public Collection getFieldScreens() {
        if (this.fieldScreens == null) {
            this.fieldScreens = this.fieldScreenManager.getFieldScreens();
        }
        return this.fieldScreens;
    }

    public List getTransitionSteps() {
        List transitions = this.getWorkflow().getDescriptor().getSteps();
        if (this.getTransition().getUnconditionalResult().getStep() == -1) {
            StepDescriptor dummyStep = new DescriptorFactory().createStepDescriptor();
            dummyStep.setId(-1);
            dummyStep.setName(this.getText("admin.workflowtransitions.same.destination.step"));
            transitions.add(dummyStep);
        }
        return transitions;
    }

    public boolean isGlobal() {
        return this.getWorkflow().isGlobalAction(this.getTransition());
    }
}

