/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugin.workflow.WorkflowConditionDescriptorEditPreprocessor;
import com.atlassian.jira.plugin.workflow.WorkflowConditionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.atlassian.jira.web.action.admin.workflow.AbstractEditWorkflowTransitionDescriptorParams;
import com.atlassian.jira.web.action.util.workflow.WorkflowEditorTransitionConditionUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import java.util.Map;

@WebSudoRequired
@AdminOnly
public class EditWorkflowTransitionConditionParams
extends AbstractEditWorkflowTransitionDescriptorParams {
    WorkflowEditorTransitionConditionUtil wetcu = new WorkflowEditorTransitionConditionUtil();

    public EditWorkflowTransitionConditionParams(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService, ModuleDescriptorFactory moduleDescriptorFactory) {
        super(workflow, step, transition, pluginAccessor, workflowService, moduleDescriptorFactory);
    }

    public EditWorkflowTransitionConditionParams(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService, ModuleDescriptorFactory moduleDescriptorFactory) {
        super(workflow, transition, pluginAccessor, workflowService, moduleDescriptorFactory);
    }

    @Override
    protected String getHighLightParamPrefix() {
        return "workflow-condition";
    }

    @Override
    protected void setupWorkflowDescriptor() {
        RestrictionDescriptor restriction = this.getTransition().getRestriction();
        if (restriction != null) {
            ConditionsDescriptor conditionsDescriptor = this.wetcu.getParentConditionsDescriptor(restriction, this.getCount());
            if (conditionsDescriptor != null) {
                List conditions = conditionsDescriptor.getConditions();
                if (conditions.size() >= this.getIndexCount()) {
                    Object descriptor = conditions.get(this.getIndexCount() - 1);
                    if (descriptor instanceof ConditionDescriptor) {
                        this.setWorkflowDescriptor((AbstractDescriptor)((ConditionDescriptor)descriptor));
                    } else if (descriptor instanceof ConditionsDescriptor) {
                        this.addErrorMessage(this.getText("admin.errors.workflows.cannot.edit.condition.descriptor"));
                    } else {
                        this.addErrorMessage(this.getText("admin.errors.workflows.invalid.condition.descriptor"));
                    }
                } else {
                    this.addErrorMessage(this.getText("admin.errors.workflows.count.outside.range", "'" + this.getIndexCount() + "'"));
                }
            } else {
                this.addErrorMessage(this.getText("admin.errors.workflows.no.condition.descriptor", "'" + this.getTransition().getName() + "'"));
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.workflows.no.restrictions.descriptor", "'" + this.getTransition().getName() + "'"));
        }
    }

    @Override
    protected String getPluginType() {
        return "workflow-condition";
    }

    @Override
    protected void editWorkflowDescriptor(AbstractDescriptor descriptor, Map params) {
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        Map conditionArgs = conditionDescriptor.getArgs();
        WorkflowConditionModuleDescriptor conditionModuleDescriptor = (WorkflowConditionModuleDescriptor)this.getDescriptor();
        WorkflowPluginConditionFactory workflowPluginConditionFactory = (WorkflowPluginConditionFactory)conditionModuleDescriptor.getModule();
        conditionArgs.putAll(workflowPluginConditionFactory.getDescriptorParams(this.getDescriptorParams()));
        if (workflowPluginConditionFactory instanceof WorkflowConditionDescriptorEditPreprocessor) {
            ((WorkflowConditionDescriptorEditPreprocessor)workflowPluginConditionFactory).beforeSaveOnEdit(conditionDescriptor);
        }
    }

    @Override
    public String getWorkflowDescriptorName() {
        return this.getDescriptor().getName() + " Condition";
    }
}

