/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowPropertyEditor;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.net.URLEncoder;
import java.util.Map;

@WebSudoRequired
@AdminOnly
public class ViewWorkflowStepMetaAttributes
extends AbstractWorkflowAction {
    private final StepDescriptor step;
    private final WorkflowPropertyEditor.WorkflowPropertyEditorFactory editor;
    private Map<String, String> metaAtrributes;
    private String attributeKey;
    private String attributeValue;

    public ViewWorkflowStepMetaAttributes(JiraWorkflow workflow, StepDescriptor step, WorkflowPropertyEditor.WorkflowPropertyEditorFactory editor) {
        super(workflow);
        this.step = step;
        this.editor = editor;
        this.initializeAndFilterAttributes();
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    private Map<String, String> getEntityMetaAttributes() {
        return this.step.getMetaAttributes();
    }

    private String getViewRedirect() throws Exception {
        return this.getRedirect("ViewWorkflowStepMetaAttributes.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId());
    }

    public String getRemoveAttributeUrl(String key) {
        return "RemoveWorkflowStepMetaAttribute.jspa" + this.getBasicWorkflowParameters() + "&atl_token=" + this.getXsrfToken() + "&workflowStep=" + this.getStep().getId() + "&attributeKey=" + URLEncoder.encode(key);
    }

    public StepDescriptor getStep() {
        return this.step;
    }

    private void initializeAndFilterAttributes() {
        this.metaAtrributes = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : this.getEntityMetaAttributes().entrySet()) {
            String key = entry.getKey();
            if (WorkflowUtil.isReservedKey((String)key)) continue;
            this.metaAtrributes.put(key, entry.getValue());
        }
    }

    public Map<String, String> getMetaAttributes() {
        return this.metaAtrributes;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddMetaAttribute() throws Exception {
        ServiceOutcome<WorkflowPropertyEditor.Result> outcome = this.createEditor().addProperty(this.attributeKey, this.attributeValue);
        if (!outcome.isValid()) {
            this.addErrorCollection(outcome.getErrorCollection());
            return "input";
        }
        return this.getViewRedirect();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doRemoveMetaAttribute() throws Exception {
        ServiceOutcome<WorkflowPropertyEditor.Result> outcome = this.createEditor().deleteProperty(this.attributeKey);
        if (!outcome.isValid()) {
            this.addErrorCollection(outcome.getErrorCollection());
            return "input";
        }
        return this.getViewRedirect();
    }

    private WorkflowPropertyEditor createEditor() {
        return this.editor.stepPropertyEditor(this.workflow, this.step).nameKey("attributeKey").valueKey("attributeValue");
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }
}

