/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.List;

@WebSudoRequired
@AdminOnly
public class ViewSchemes
extends JiraWebActionSupport {
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ConstantsManager constantsManager;
    private List<AssignableWorkflowScheme> activeSchemes;
    private List<AssignableWorkflowScheme> inactiveSchemes;

    public ViewSchemes(WorkflowSchemeManager workflowSchemeManager, ConstantsManager constantsManager) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.constantsManager = constantsManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.activeSchemes = Lists.newArrayList();
        this.inactiveSchemes = Lists.newArrayList();
        for (AssignableWorkflowScheme scheme : this.workflowSchemeManager.getAssignableSchemes()) {
            if (this.workflowSchemeManager.isActive((WorkflowScheme)scheme)) {
                this.activeSchemes.add(scheme);
                continue;
            }
            this.inactiveSchemes.add(scheme);
        }
        return super.doExecute();
    }

    public boolean isHasScheme() {
        return !this.getActiveWorkflowSchemes().isEmpty() || !this.getInactiveWorkflowSchemes().isEmpty();
    }

    public List<AssignableWorkflowScheme> getActiveWorkflowSchemes() {
        return this.activeSchemes;
    }

    public List<AssignableWorkflowScheme> getInactiveWorkflowSchemes() {
        return this.inactiveSchemes;
    }

    public List<Project> getProjects(AssignableWorkflowScheme scheme) {
        return this.workflowSchemeManager.getProjectsUsing(scheme);
    }

    public DraftWorkflowScheme getDraftFor(AssignableWorkflowScheme scheme) {
        return this.workflowSchemeManager.getDraftForParent(scheme);
    }

    public IssueType getIssueType(String type) {
        return this.constantsManager.getIssueType(type);
    }
}

