/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.util.UtilDateTime;

@AnonymousSiteAccess
public class AddComment
extends AbstractCommentableIssue
implements OperationContext {
    protected final PermissionManager permissionManager;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final QueryDslAccessor queryDslAccessor;

    public AddComment(SubTaskManager subTaskManager, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, ProjectRoleManager projectRoleManager, CommentService commentService, PermissionManager permissionManager, UserUtil userUtil, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory, QueryDslAccessor queryDslAccessor) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.permissionManager = permissionManager;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doDefault() {
        try {
            if (!this.isAbleToComment()) {
                return "error";
            }
        }
        catch (IssueNotFoundException e) {
            this.getErrorMessages().clear();
            return "error";
        }
        catch (IssuePermissionException ipe) {
            this.getErrorMessages().clear();
            return "error";
        }
        this.requireAttachmentsResources();
        return "input";
    }

    public boolean isAbleToComment() {
        return this.getIssue() == null ? this.permissionManager.hasPermission(15, this.getIssueObject().getProjectObject(), this.getLoggedInUser()) : this.permissionManager.hasPermission(15, this.getIssueObject(), this.getLoggedInUser());
    }

    @Override
    protected void doValidation() {
        try {
            super.doCommentValidation(false);
        }
        catch (IssueNotFoundException issueNotFoundException) {
        }
        catch (IssuePermissionException issuePermissionException) {
            // empty catch block
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        Comment comment = this.createComment();
        this.alertSystemOfComment(comment);
        if (StringUtils.isNotBlank((CharSequence)this.getReturnUrl())) {
            return this.returnCompleteWithInlineRedirect(this.getReturnUrl());
        }
        String browseIssue = "/browse/" + this.getIssue().getString("key");
        if (comment != null) {
            return this.returnComplete(browseIssue + "?focusedId=" + comment.getId() + "#comment-" + comment.getId());
        }
        return this.returnComplete(browseIssue);
    }

    @VisibleForTesting
    void alertSystemOfComment(Comment comment) throws GenericEntityException {
        Issue issueObject = this.getIssueObject();
        this.queryDslAccessor.execute(dbConnection -> dbConnection.update((RelationalPath<?>)QIssue.ISSUE).set(QIssue.ISSUE.updated, (Object)UtilDateTime.nowTimestamp()).where((Predicate)QIssue.ISSUE.id.eq((Object)issueObject.getId())).execute());
        Map<String, Object> params = this.createIssueEventParameters();
        this.issueEventManager.dispatchRedundantEvent(EventType.ISSUE_COMMENTED_ID, issueObject, this.getLoggedInUser(), comment, null, null, params);
        IssueEventBundle issueCommentBundle = this.issueEventBundleFactory.createCommentAddedBundle(issueObject, this.getLoggedInUser(), comment, params);
        this.issueEventManager.dispatchEvent(issueCommentBundle);
    }

    private Map<String, Object> createIssueEventParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventsource", "action");
        return params;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

