/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeId;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.UserIssueTypeManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.action.issue.Assignable;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.action.issue.util.ScreenTabErrorHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import webwork.action.ActionContext;

@AnonymousSiteAccess
public class CreateIssue
extends AbstractIssueSelectAction
implements Assignable,
OperationContext {
    protected final IssueCreationHelperBean issueCreationHelperBean;
    private final IssueFactory issueFactory;
    private Long pid;
    private String issuetype;
    protected Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private FieldScreenRenderer fieldScreenRenderer;
    private SortedSet tabsWithErrors;
    private int selectedTab = 1;
    private Collection<String> ignoreFieldIds = Lists.newArrayList((Object[])new String[]{"issuetype"});

    public CreateIssue(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean) {
        this.issueFactory = issueFactory;
        this.issueCreationHelperBean = issueCreationHelperBean;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.issueCreationHelperBean.validateLicense((ErrorCollection)this, (I18nHelper)this);
        if (this.hasAnyErrors()) {
            return "invalidlicense";
        }
        Optional<Project> userSelectedProject = Optional.ofNullable(this.getProjectObject());
        Optional<Project> lastProject = Optional.ofNullable(this.getUserProjectHistoryManager().getCurrentProject(11, this.getLoggedInUser()));
        boolean projectChanged = this.isProjectChanged(userSelectedProject.map(Project::getId).orElse(null), lastProject.map(Project::getId).orElse(null));
        if (userSelectedProject.isPresent()) {
            this.setSelectedProject(userSelectedProject.get());
        }
        Project current = this.getSelectedProjectObject();
        Long requestedPid = this.getPid();
        if (current != null && this.getAllowedProjects().contains(current)) {
            if (this.pid == null) {
                this.pid = current.getId();
            }
            this.getFieldValuesHolder().put("project", this.pid);
        }
        String requestedIssueType = this.getIssuetype();
        this.setHistoryIssuetype(projectChanged);
        if (this.prepareFieldsIfOneOption(requestedPid, requestedIssueType)) {
            return this.getRedirectForCreateBypass();
        }
        return super.doDefault();
    }

    private boolean isProjectChanged(Long userSelectedProjectId, Long lastUsedProjectId) {
        if (userSelectedProjectId == null) {
            return false;
        }
        return userSelectedProjectId != null && lastUsedProjectId != null ? !userSelectedProjectId.equals(lastUsedProjectId) : true;
    }

    protected String getRedirectForCreateBypass() {
        return this.forceRedirect("CreateIssue.jspa?pid=" + this.getPid() + "&issuetype=" + this.getIssuetype());
    }

    protected void setHistoryIssuetype(boolean projectChanged) {
        if (this.issuetype == null && projectChanged) {
            IssueTypeSchemeManager issueTypeSchemeManager = ComponentAccessor.getIssueTypeSchemeManager();
            Optional<IssueType> defaultIssueTypeOpt = Optional.ofNullable(issueTypeSchemeManager.getDefaultIssueType(this.getProject()));
            defaultIssueTypeOpt.ifPresent(issueType -> {
                this.issuetype = issueType.getId();
            });
        }
        if (this.issuetype == null) {
            Optional lastUsedIssueTypeId = ((UserIssueTypeManager)ComponentAccessor.getComponent(UserIssueTypeManager.class)).getLastUsedIssueTypeId(this.getLoggedInUser());
            lastUsedIssueTypeId.ifPresent(issueTypeId -> {
                this.issuetype = issueTypeId.getId();
            });
        }
        if (this.issuetype == null) {
            this.issuetype = this.getApplicationProperties().getString("jira.constant.default.issue.type");
        }
        this.getFieldValuesHolder().put("issuetype", this.issuetype);
    }

    protected void doValidation() {
        try {
            this.issueCreationHelperBean.validateProject((Issue)this.getIssueObject(), (OperationContext)this, ActionContext.getParameters(), (ErrorCollection)this, (I18nHelper)this);
            if (!this.invalidInput()) {
                this.getIssueObject().setProjectId(this.getPid());
            }
            this.issueCreationHelperBean.validateIssueType((Issue)this.getIssueObject(), (OperationContext)this, ActionContext.getParameters(), (ErrorCollection)this, (I18nHelper)this);
            if (!this.invalidInput()) {
                this.getIssueObject().setIssueTypeId(this.getIssuetype());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage("An exception occurred: " + e + ".");
        }
    }

    protected void validateIssueType() {
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.getField("issuetype");
        issueTypeField.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
        issueTypeField.validateParams(this, (ErrorCollection)this, (I18nHelper)this, (Issue)this.getIssueObject(), this.getFieldScreenRenderer().getFieldScreenRenderLayoutItem((OrderableField)issueTypeField));
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.issueCreationHelperBean.validateLicense((ErrorCollection)this, (I18nHelper)this);
        if (this.hasAnyErrors()) {
            return "invalidlicense";
        }
        ProjectSystemField projectField = (ProjectSystemField)this.getField("project");
        projectField.updateIssue(null, this.getIssueObject(), this.getFieldValuesHolder());
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.getField("issuetype");
        issueTypeField.updateIssue(null, this.getIssueObject(), this.getFieldValuesHolder());
        this.recordHistoryIssueType();
        this.setSelectedProjectId(this.getPid());
        this.populateFieldHolderWithDefaults((Issue)this.getIssueObject(), Collections.emptyList());
        return "success";
    }

    public MutableIssue getIssueObject() {
        if (this.getIssueObjectWithoutDatabaseRead() == null) {
            this.setIssueObject((Issue)this.issueFactory.getIssue());
            this.getIssueObject().setProjectId(this.getPid());
            this.getIssueObject().setIssueTypeId(this.getIssuetype());
        }
        return this.getIssueObjectWithoutDatabaseRead();
    }

    protected void recordHistoryIssueType() {
        ((UserIssueTypeManager)ComponentAccessor.getComponent(UserIssueTypeManager.class)).setLastUsedIssueTypeId(this.getLoggedInUser(), new IssueTypeId(this.issuetype));
    }

    public Collection<Project> getAllowedProjects() {
        return this.getPermissionManager().getProjects(ProjectPermissions.CREATE_ISSUES, this.getLoggedInUser());
    }

    public boolean isAbleToCreateIssueInSelectedProject() {
        return this.getAllowedProjects().contains(this.getProjectObject());
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Override
    public Project getProjectObject() {
        return this.getProjectManager().getProjectObj(this.getPid());
    }

    public String getIssuetype() {
        return this.issuetype;
    }

    public void setIssuetype(String issueType) {
        this.issuetype = issueType;
    }

    public IssueType getIssueType() {
        return ComponentAccessor.getConstantsManager().getIssueType(this.getIssuetype());
    }

    @Override
    public String getAssignee() {
        return null;
    }

    @Override
    public void setAssignee(String assignee) {
    }

    public List getFieldScreenRenderTabs() {
        return this.getFieldScreenRenderer().getFieldScreenRenderTabs();
    }

    protected FieldScreenRenderer getFieldScreenRenderer() {
        if (this.fieldScreenRenderer == null) {
            this.fieldScreenRenderer = this.issueCreationHelperBean.createFieldScreenRenderer((Issue)this.getIssueObject());
        }
        return this.fieldScreenRenderer;
    }

    @Override
    public Project getAssignIn() throws Exception {
        return this.getProjectObject();
    }

    protected void populateFieldHolderWithDefaults(Issue issue, Collection excludedFieldIds) {
        for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderTabLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                String fieldId = fieldScreenRenderTabLayoutItem.getOrderableField().getId();
                if (excludedFieldIds.contains(fieldId) || "project".equals(fieldId) || "issuetype".equals(fieldId)) continue;
                fieldScreenRenderTabLayoutItem.populateDefaults(this.getFieldValuesHolder(), issue);
            }
        }
    }

    public List<CustomField> getCustomFields(Issue issue) {
        return this.getCustomFieldManager().getCustomFieldObjects(issue.getProjectId(), issue.getIssueTypeId());
    }

    public Map<String, Object> getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.CREATE_ISSUE_OPERATION;
    }

    public List<ButtonHolder> getButtons() throws WorkflowException {
        ArrayList buttons = Lists.newArrayList();
        Map buttonAttrs = this.getWorkflowMetaAttributes();
        for (Object o : buttonAttrs.keySet()) {
            String key = (String)o;
            String val = (String)buttonAttrs.get(key);
            buttons.add(new ButtonHolder(key, this.getText(val)));
        }
        return buttons;
    }

    private Map getWorkflowMetaAttributes() throws WorkflowException {
        JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(this.getPid(), this.getIssuetype());
        return workflow.getDescriptor().getInitialAction(1).getMetaAttributes();
    }

    public boolean hasProjectPermission(int permissionsId, Project project) {
        if (project == null) {
            throw new IllegalArgumentException("isHasProjectPermission can not be passed a null project");
        }
        return this.getPermissionManager().hasPermission(new ProjectPermissionKey(permissionsId), project, this.getLoggedInUser(), true);
    }

    public Collection getTabsWithErrors() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.tabsWithErrors;
    }

    private void initTabsWithErrors() {
        this.tabsWithErrors = new TreeSet();
        this.selectedTab = new ScreenTabErrorHelper().initialiseTabsWithErrors(this.tabsWithErrors, this.getErrors(), this.getFieldScreenRenderer(), ActionContext.getParameters());
    }

    public int getSelectedTab() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.selectedTab;
    }

    public Collection getIgnoreFieldIds() {
        return this.ignoreFieldIds;
    }

    public String getSubmitButtonName() {
        try {
            JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(this.getPid(), this.getIssuetype());
            return super.getWorkflowTransitionDisplayName(workflow.getDescriptor().getInitialAction(1));
        }
        catch (WorkflowException e) {
            this.log.error((Object)e, (Throwable)e);
            return "Create";
        }
    }

    private boolean hasProjectIdRequestParamSet() {
        try {
            return new Long(this.request.getParameter("pid")) != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    boolean prepareFieldsIfOneOption(Long requestedPid, String requestedIssueTypeId) {
        Project project;
        Long projectId = requestedPid;
        if (projectId == null) {
            Collection<Project> projects = this.getAllowedProjects();
            if (projects.size() != 1) {
                return false;
            }
            projectId = projects.iterator().next().getId();
        }
        if ((project = this.projectManager.getProjectObj(projectId)) != null) {
            Collection issueTypes = this.getIssueTypesForProject(project);
            if (requestedIssueTypeId == null) {
                if (issueTypes.size() == 1) {
                    IssueType issueType = (IssueType)issueTypes.iterator().next();
                    this.setPid(project.getId());
                    this.setIssuetype(issueType.getId());
                    return true;
                }
            } else {
                for (Object issueType1 : issueTypes) {
                    IssueType issueType = (IssueType)issueType1;
                    if (!issueType.getId().equals(requestedIssueTypeId)) continue;
                    this.setPid(project.getId());
                    this.setIssuetype(requestedIssueTypeId);
                    return true;
                }
            }
        }
        return false;
    }

    protected Collection getIssueTypesForProject(Project project) {
        IssueTypeSchemeManager issueTypeSchemeManager = ComponentAccessor.getIssueTypeSchemeManager();
        return issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project);
    }

    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }

    public static class ButtonHolder {
        private final String name;
        private final String value;

        public ButtonHolder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

