/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import java.util.Map;
import webwork.action.Action;

@AnonymousSiteAccess
public class DeleteComment
extends AbstractIssueSelectAction {
    private static final String ERROR_KEY_NO_ASSOC_ISSUE = "edit.comment.no.associated.issue";
    private static final String ERROR_NO_PERMISSION = "errorNoPermission";
    private Long id;
    private FieldScreenRenderer fieldScreenRendererWithAllFields;
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    private CommentService commentService;
    private Comment commentObject;

    public DeleteComment(FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService) {
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.commentService = commentService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        return this.commentService.hasPermissionToDelete(this.getJiraServiceContext(), this.getCommentId()) ? "input" : ERROR_NO_PERMISSION;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (!this.commentService.hasPermissionToDelete(this.getJiraServiceContext(), this.getCommentId())) {
            return ERROR_NO_PERMISSION;
        }
        String issueKey = this.getIssueObject().getKey();
        this.commentService.delete(this.getJiraServiceContext(), this.getCommentObject(), true);
        Issue issue = this.getCommentObject().getIssue();
        if (issue == null) {
            this.addErrorMessage(this.getText(ERROR_KEY_NO_ASSOC_ISSUE, this.getCommentObject().getId()));
            return "error";
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        String baseUrl = "/browse/" + issue.getKey();
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl);
        urlBuilder.addParameter("page", "com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
        return this.returnComplete(urlBuilder.asUrlString());
    }

    public void setCommentId(Long id) {
        this.id = id;
    }

    public Long getCommentId() {
        return this.id;
    }

    @Override
    public String getIssuePath() {
        return "/browse/" + this.getIssueObject().getKey();
    }

    public String getRenderedContent() {
        OrderableField field = (OrderableField)this.getField("comment");
        FieldLayoutItem fieldLayoutItem = this.getFieldScreenRendererLayoutItemForField(field).getFieldLayoutItem();
        Map value = EasyMap.build((Object)field.getId(), (Object)this.getCommentObject().getBody());
        return fieldLayoutItem.getOrderableField().getViewHtml(fieldLayoutItem, (Action)this, this.getIssueObject(), (Object)value, null);
    }

    public FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(OrderableField field) {
        return this.getFieldScreenRendererWithAllFields().getFieldScreenRenderLayoutItem(field);
    }

    protected FieldScreenRenderer getFieldScreenRendererWithAllFields() {
        if (this.fieldScreenRendererWithAllFields == null) {
            this.fieldScreenRendererWithAllFields = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getIssueObject(), (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
        }
        return this.fieldScreenRendererWithAllFields;
    }

    public Comment getCommentObject() {
        if (this.commentObject == null) {
            this.commentObject = this.commentService.getCommentById(this.getLoggedInUser(), this.getCommentId(), (ErrorCollection)this);
        }
        return this.commentObject;
    }

    public String getCommentAuthorKey() {
        ApplicationUser commentAuthor = this.getCommentObject().getAuthorApplicationUser();
        return commentAuthor == null ? null : commentAuthor.getKey();
    }

    public String getCommentUpdateAuthorKey() {
        ApplicationUser commentUpdater = this.getCommentObject().getUpdateAuthorApplicationUser();
        return commentUpdater == null ? null : commentUpdater.getKey();
    }
}

