/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableAssignableIssue;
import com.atlassian.jira.web.action.issue.util.ScreenTabErrorHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import webwork.action.ActionContext;

@AnonymousSiteAccess
public class EditIssue
extends AbstractCommentableAssignableIssue
implements OperationContext {
    private final ConstantsManager constantsManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final WorkflowManager workflowManager;
    private FieldScreenRenderer fieldScreenRenderer;
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueService issueService;
    private SortedSet tabsWithErrors;
    private int selectedTab;
    private IssueService.UpdateValidationResult updateValidationResult;
    private Collection ignoreFieldIds = new LinkedList();

    public EditIssue(SubTaskManager subTaskManager, ConstantsManager constantsManager, FieldLayoutManager fieldLayoutManager, WorkflowManager workflowManager, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueService issueService, UserUtil userUtil, UserManager userManager) {
        super(subTaskManager, fieldScreenRendererFactory, commentService, userUtil, userManager);
        this.constantsManager = constantsManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.workflowManager = workflowManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueService = issueService;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        try {
            if (!this.isEditable()) {
                return "error";
            }
        }
        catch (IssuePermissionException ipe) {
            return "issue-permission-error";
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                if (!fieldScreenRenderLayoutItem.isShow(this.getIssueObject())) continue;
                fieldScreenRenderLayoutItem.populateFromIssue(this.getFieldValuesHolder(), this.getIssueObject());
            }
        }
        return super.doDefault();
    }

    protected FieldScreenRenderer getFieldScreenRenderer() {
        if (this.fieldScreenRenderer == null) {
            this.fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getIssueObject(), (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
        }
        return this.fieldScreenRenderer;
    }

    @Override
    protected void doValidation() {
        this.requireAttachmentsResources();
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters(ActionContext.getParameters());
        issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(false);
        this.updateValidationResult = this.issueService.validateUpdate(this.getLoggedInUser(), this.getIssueObject().getId(), issueInputParameters);
        this.setIssueObject((Issue)this.updateValidationResult.getIssue());
        this.setFieldValuesHolder(this.updateValidationResult.getFieldValuesHolder());
        if (!this.updateValidationResult.isValid()) {
            this.addErrorCollection(this.updateValidationResult.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.requireAttachmentsResources();
        try {
            IssueService.IssueResult issueResult = this.issueService.update(this.getLoggedInUser(), this.updateValidationResult);
            if (!issueResult.isValid()) {
                this.addErrorCollection(issueResult.getErrorCollection());
            }
            if (this.isInlineDialogMode()) {
                return this.returnComplete();
            }
            return this.getRedirect(this.getViewUrl());
        }
        catch (Exception issueEditException) {
            this.addErrorMessage(this.getText("admin.errors.issues.exception.occured", issueEditException));
            this.log.error((Object)("An exception occurred editing issue: " + this.getIssueObject().getKey()), (Throwable)issueEditException);
            return "error";
        }
    }

    public List getFieldScreenRenderTabs() {
        return this.getFieldScreenRenderer().getFieldScreenRenderTabs();
    }

    public Collection getTabsWithErrors() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.tabsWithErrors;
    }

    private void initTabsWithErrors() {
        this.tabsWithErrors = new TreeSet();
        this.selectedTab = new ScreenTabErrorHelper().initialiseTabsWithErrors(this.tabsWithErrors, this.getErrors(), this.getFieldScreenRenderer(), ActionContext.getParameters());
    }

    public int getSelectedTab() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.selectedTab;
    }

    @Override
    public IssueOperation getIssueOperation() {
        return IssueOperations.EDIT_ISSUE_OPERATION;
    }

    public ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    public FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public WorkflowManager getWorkflowManager() {
        return this.workflowManager;
    }

    public Collection getIgnoreFieldIds() {
        return this.ignoreFieldIds;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

