/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.issue.BugAssociatorPrefs;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSearchRequestManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
public class IssuePicker
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(IssuePicker.class);
    private static final String RECENT = "recent";
    private static final String SEARCH = "search";
    private static final int MAX_ISSUES_RETURNED = 50;
    private static final PagerFilter PAGER_FILTER = new PagerFilter(50);
    private static final String SELECT_SINGLE = "single";
    private static final String SELECT_MULTIPLE = "multiple";
    private final BugAssociatorPrefs bugAssociatorPrefs;
    private final IssueManager issueManager;
    private final SearchService searchService;
    private final SearchRequestService searchRequestService;
    private final UserIssueHistoryManager userHistoryManager;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    private String mode = null;
    private String selectMode = null;
    private long searchRequestId = -1L;
    private String currentIssue;
    private boolean singleSelectOnly = false;
    private boolean showSubTasks = true;
    private boolean showSubTasksParent;
    private Long selectedProjectId = null;
    private SearchRequest searchRequest;

    public IssuePicker(BugAssociatorPrefs bugAssociatorPrefs, IssueManager issueManager, SearchService searchService, SearchRequestService searchRequestService, UserIssueHistoryManager userHistoryManager, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory) {
        this.bugAssociatorPrefs = bugAssociatorPrefs;
        this.issueManager = issueManager;
        this.searchService = searchService;
        this.searchRequestService = searchRequestService;
        this.userHistoryManager = userHistoryManager;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public Collection<SearchRequest> getAvailableFilters() {
        return this.searchRequestService.getFavouriteFilters(this.getLoggedInUser());
    }

    public Collection<Issue> getSearchRequestIssues() {
        if (this.getSearchRequestId() == -1L) {
            log.warn("Trying to search for issues with no search request Id.");
            return Collections.emptyList();
        }
        this.searchRequest = this.searchRequestService.getFilter(this.getJiraServiceContext(), Long.valueOf(this.getSearchRequestId()));
        if (this.searchRequest == null) {
            log.warn("Search request Id not valid for this user.");
            return Collections.emptyList();
        }
        return this.executeSearch(this.searchRequest);
    }

    public Collection<Issue> getUserHistoryIssues() {
        return this.filterIssues(this.userHistoryManager.getShortIssueHistory(this.getLoggedInUser()));
    }

    public Collection<Issue> getBrowsableIssues() {
        SessionSearchRequestManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createSearchRequestManager();
        SearchRequest currentSearch = (SearchRequest)sessionSearchRequestManager.getCurrentObject();
        return this.executeSearch(currentSearch);
    }

    private Collection<Issue> executeSearch(SearchRequest searchRequest) {
        try {
            SearchResults searchResults = this.searchService.search(this.getLoggedInUser(), searchRequest == null ? null : searchRequest.getQuery(), PAGER_FILTER);
            return this.filterIssues(searchResults.getResults());
        }
        catch (SearchException e) {
            log.error("Unable to run search in issue picker.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean showIssue(Issue issue) {
        if (this.selectedProjectId != null && !this.selectedProjectId.equals(issue.getProjectId())) {
            return false;
        }
        if (!this.showSubTasks && issue.isSubTask()) {
            return false;
        }
        if (this.currentIssue != null) {
            if (this.currentIssue.equals(issue.getKey())) {
                return false;
            }
            Issue currentIssue = this.getIssue();
            if (currentIssue != null && !this.showSubTasksParent && currentIssue.isSubTask() && currentIssue.getParentId().equals(issue.getId())) {
                return false;
            }
        }
        return true;
    }

    private Collection<Issue> filterIssues(Collection<? extends Issue> issues) {
        if (issues == null || issues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Issue> result = new ArrayList<Issue>(issues.size());
        for (Issue issue : issues) {
            if (!this.showIssue(issue)) continue;
            result.add(issue);
        }
        return result;
    }

    private Issue getIssue() {
        return this.issueManager.getIssueObject(this.currentIssue);
    }

    private String getDefaultMode() {
        int mode = this.bugAssociatorPrefs.getDefaultMode(this.getIssue());
        if (1 == mode) {
            return RECENT;
        }
        return SEARCH;
    }

    private String getDefaultSelectMode() {
        int searchMode = this.bugAssociatorPrefs.getDefaultSearchMode(this.getIssue());
        if (17 == searchMode) {
            return SELECT_SINGLE;
        }
        if (19 == searchMode) {
            return SELECT_MULTIPLE;
        }
        return SELECT_SINGLE;
    }

    public long getSearchRequestId() {
        if (this.searchRequestId == -1L) {
            return this.bugAssociatorPrefs.getDefaultSearchRequestId(this.getIssue());
        }
        return this.searchRequestId;
    }

    public void setSearchRequestId(long searchRequestId) {
        this.searchRequestId = searchRequestId;
    }

    public String getSearchRequestName() {
        return this.searchRequest != null ? this.searchRequest.getName() : "";
    }

    public String getCurrentIssue() {
        return this.currentIssue;
    }

    public void setCurrentIssue(String currentIssue) {
        this.currentIssue = currentIssue;
    }

    public String getMode() {
        if (this.mode == null || SEARCH.equals(this.mode) && this.searchRequestId < 0L) {
            this.mode = this.getDefaultMode();
        }
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setSelectMode(String selectMode) {
        this.selectMode = selectMode;
    }

    public String getSelectMode() {
        if (this.selectMode == null) {
            this.selectMode = this.getDefaultSelectMode();
        }
        return this.selectMode;
    }

    public boolean isSingleSelectOnly() {
        return this.singleSelectOnly;
    }

    public void setSingleSelectOnly(boolean singleSelectOnly) {
        this.singleSelectOnly = singleSelectOnly;
    }

    public Long getSelectedProjectId() {
        return this.selectedProjectId;
    }

    public void setSelectedProjectId(Long selectedProjectId) {
        this.selectedProjectId = selectedProjectId;
    }

    public boolean isShowSubTasks() {
        return this.showSubTasks;
    }

    public void setShowSubTasks(boolean showSubTasks) {
        this.showSubTasks = showSubTasks;
    }

    public boolean isShowSubTasksParent() {
        return this.showSubTasksParent;
    }

    public void setShowSubTasksParent(boolean showSubTasksParent) {
        this.showSubTasksParent = showSubTasksParent;
    }
}

