/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueVerifier;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityHelper;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.transformers.IssueChangeHolderTransformer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.issue.MoveIssueUpdateFields;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import webwork.action.Action;

@LicensedOnly
public class MoveIssueConfirm
extends MoveIssueUpdateFields {
    boolean confirm = false;
    private final AttachmentManager attachmentManager;
    private final IssueManager issueManager;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final TxnAwareEventFactory txnAwareEventFactory;

    public MoveIssueConfirm(SubTaskManager subTaskManager, AttachmentManager attachmentManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutmanager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueSecurityHelper issueSecurityHelper, IssueManager issueManager, UserUtil userUtil, UserManager userManager, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory, TxnAwareEventFactory txnAwareEventFactory, HelpUrls helpUrls) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutmanager, issueFactory, fieldScreenRendererFactory, commentService, issueSecurityHelper, userUtil, userManager, helpUrls);
        this.attachmentManager = attachmentManager;
        this.issueManager = issueManager;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.txnAwareEventFactory = txnAwareEventFactory;
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (this.isSubTask()) {
            this.getMoveIssueBean().setCurrentStep(3);
            this.getMoveIssueBean().addAvailablePreviousStep(2);
        } else {
            this.getMoveIssueBean().setCurrentStep(4);
            this.getMoveIssueBean().addAvailablePreviousStep(3);
        }
        return "input";
    }

    public Collection getConfimationFieldLayoutItems() {
        return this.getMoveIssueBean().getMoveFieldLayoutItems();
    }

    public Collection getRemoveFields() {
        return this.getMoveIssueBean().getRemovedFields();
    }

    public String getOldViewHtml(OrderableField field) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.getIssueObject());
        FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(field);
        Map displayParams = MapBuilder.newBuilder((Object)"nolink", (Object)Boolean.TRUE).add((Object)"readonly", (Object)Boolean.TRUE).add((Object)"prefix", (Object)"old_").toMutableMap();
        return field.getViewHtml(fieldLayoutItem, (Action)this, (Issue)this.getIssueObject(this.getIssue()), displayParams);
    }

    public String getNewViewHtml(OrderableField field) {
        MutableIssue updatedIssue = this.getMoveIssueBean().getUpdatedIssue();
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(updatedIssue.getProjectObject(), updatedIssue.getIssueTypeId());
        FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(field);
        Map displayParams = MapBuilder.newBuilder((Object)"nolink", (Object)Boolean.TRUE).add((Object)"readonly", (Object)Boolean.TRUE).add((Object)"prefix", (Object)"new_").add((Object)"escapeHtml", (Object)Boolean.TRUE).toMutableMap();
        return field.getViewHtml(fieldLayoutItem, (Action)this, (Issue)updatedIssue, displayParams);
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            try {
                this.validateAttachmentMove();
                this.validateCreateIssue();
            }
            catch (GenericEntityException e) {
                this.log.error((Object)"Error occurred while moving issue.", (Throwable)e);
                this.addErrorMessage(this.getText("moveissue.error.attachment"));
            }
            if (!this.isConfirm()) {
                this.addErrorMessage(this.getText("admin.errors.error.occured.moving.issue"));
            }
        }
    }

    @Override
    protected void popluateDefault(OrderableField orderableField) {
    }

    @Override
    protected void populateFromParams(OrderableField orderableField) {
    }

    @Override
    protected MutableIssue getTargetIssueObject() {
        return this.getMoveIssueBean().getUpdatedIssue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        MutableIssue originalIssueObject = this.getIssueManager().getIssueObject(this.getMoveIssueBean().getUpdatedIssue().getId());
        String sourceIssueKey = this.getMoveIssueBean().getSourceIssueKey();
        if (!originalIssueObject.getKey().equals(sourceIssueKey)) {
            this.addErrorMessage(this.getText("moveissue.error.already.moved", sourceIssueKey, originalIssueObject.getKey()));
            return "error";
        }
        String originalWfId = null;
        MutableIssue updatedIssueObject = this.getMoveIssueBean().getUpdatedIssue();
        if (updatedIssueObject.getWorkflowId() != null) {
            originalWfId = updatedIssueObject.getWorkflowId().toString();
        }
        IssueVerifier issueVerifier = new IssueVerifier();
        HashMap<String, String> workflowMigrationMapping = new HashMap<String, String>();
        workflowMigrationMapping.put(updatedIssueObject.getStatusObject().getId(), this.getTargetStatusId());
        ErrorCollection errorCollection = issueVerifier.verifyIssue((Issue)originalIssueObject, workflowMigrationMapping, true);
        if (!updatedIssueObject.isSubTask() && !updatedIssueObject.getSubTaskObjects().isEmpty()) {
            Collection subTasks = updatedIssueObject.getSubTaskObjects();
            for (Issue subtask : subTasks) {
                workflowMigrationMapping.clear();
                if (this.isTaskStatusValid(subtask.getString("type"), subtask.getString("status"))) {
                    workflowMigrationMapping.put(subtask.getString("status"), subtask.getString("status"));
                } else {
                    String key = this.getPrefixIssueTypeId(subtask.getString("type"));
                    String newIssueType = (String)this.getMoveIssueBean().getFieldValuesHolder().get(key);
                    if (newIssueType == null) {
                        newIssueType = subtask.getString("type");
                    }
                    String subTaskTypeKey = this.getPrefixTaskStatusId(newIssueType, subtask.getString("status"));
                    Map taskTargetStatusMap = this.getMoveIssueBean().getTaskTargetStatusHolder();
                    workflowMigrationMapping.put(subtask.getString("status"), (String)taskTargetStatusMap.get(subTaskTypeKey));
                }
                errorCollection.addErrorCollection(issueVerifier.verifyIssue(subtask, workflowMigrationMapping, true));
            }
        }
        if (errorCollection != null && errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
            return "workflowmigrationerror";
        }
        Transaction txn = Txn.begin();
        if (!this.getProjectObject().equals(this.getTargetProjectObj())) {
            Project project = this.getTargetProjectObj();
            updatedIssueObject.setProjectObject(project);
            long incCount = this.getProjectManager().getNextId(project);
            updatedIssueObject.setNumber(Long.valueOf(incCount));
            this.attachmentManager.moveAttachments((Issue)originalIssueObject, updatedIssueObject.getKey());
        }
        try {
            this.moveIssueInTxn(txn, originalIssueObject, updatedIssueObject, originalWfId);
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
        if (!updatedIssueObject.isSubTask() && !updatedIssueObject.getSubTaskObjects().isEmpty()) {
            this.moveSubTasks((Issue)updatedIssueObject);
        }
        return this.getRedirect("/browse/" + this.getKey());
    }

    private void moveIssueInTxn(Transaction txn, MutableIssue originalIssueObject, MutableIssue updatedIssueObject, String originalWfId) throws GenericEntityException {
        if (!this.isWorkflowMatch(this.getCurrentIssueType(), this.getTargetIssueType())) {
            this.migrateIssueToWorkflow(updatedIssueObject, this.getIssue().getString("type"), this.getWorkflowForType(this.getTargetPid(), this.getTargetIssueType()), this.getTargetStatus());
        }
        updatedIssueObject.setUpdated(new Timestamp(System.currentTimeMillis()));
        IssueChangeHolder issueChangeHolder = this.moveIssueDetails(updatedIssueObject, originalIssueObject.getKey(), originalWfId);
        GenericValue changeGroup = ChangeLogUtils.createChangeGroup(this.getLoggedInUser(), originalIssueObject.getGenericValue(), updatedIssueObject.getGenericValue(), (Collection<ChangeItemBean>)issueChangeHolder.getChangeItems(), false);
        if (this.projectIsMoved()) {
            this.issueManager.recordMovedIssueKey((Issue)originalIssueObject);
        }
        txn.commit();
        boolean sendMail = true;
        if (changeGroup != null) {
            this.txnAwareEventFactory.issueChangedEventOnCommit(updatedIssueObject.getId(), this.getLoggedInUser(), null, changeGroup.getLong("id"), sendMail);
        }
        this.dispatchIssueUpdateEvents((Issue)updatedIssueObject, changeGroup, issueChangeHolder, sendMail);
    }

    private boolean projectIsMoved() {
        return !this.getProjectObject().equals(this.getTargetProjectObj());
    }

    private void dispatchIssueUpdateEvents(Issue newIssue, GenericValue updateLog, IssueChangeHolder issueChangeHolder, boolean sendMail) throws GenericEntityException {
        if (updateLog != null && !issueChangeHolder.getChangeItems().isEmpty()) {
            Long eventTypeId = this.isSubTask() || this.getProjectObject().equals(this.getTargetProjectObj()) ? EventType.ISSUE_UPDATED_ID : EventType.ISSUE_MOVED_ID;
            this.issueEventManager.dispatchRedundantEvent(eventTypeId, newIssue, this.getLoggedInUser(), updateLog, true, issueChangeHolder.isSubtasksUpdated());
            ApplicationUser user = this.getLoggedInUser();
            IssueEventBundle issueEventBundle = this.issueEventBundleFactory.createIssueUpdateEventBundle(newIssue, updateLog, IssueChangeHolderTransformer.toIssueUpdateBean(issueChangeHolder, eventTypeId, user, sendMail), user);
            this.issueEventManager.dispatchEvent(issueEventBundle);
        }
    }

    private IssueChangeHolder moveIssueDetails(MutableIssue newIssue, String oldKey, String originalWfId) throws GenericEntityException, WorkflowException {
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        IssueType currentIssueType = this.getConstantsManager().getIssueType(this.getCurrentIssueType());
        IssueType targetIssueType = this.getConstantsManager().getIssueType(this.getTargetIssueType());
        String newKey = newIssue.getKey();
        if (!this.getProjectObject().equals(this.getTargetProjectObj())) {
            changeHolder.addChangeItem(new ChangeItemBean("jira", "project", this.getProjectObject().getId().toString(), this.getProjectObject().getName(), this.getTargetProjectObj().getId().toString(), this.getTargetProjectObj().getName()));
            changeHolder.addChangeItem(new ChangeItemBean("jira", "Key", null, oldKey, null, newKey));
        }
        if (this.isSubTask() || !this.getCurrentIssueType().equals(this.getTargetIssueType())) {
            changeHolder.addChangeItem(new ChangeItemBean("jira", "issuetype", currentIssueType.getId(), currentIssueType.getName(), targetIssueType.getId(), targetIssueType.getName()));
            newIssue.setIssueTypeObject(this.getTargetIssueTypeObject());
        }
        if (!this.isWorkflowMatch(this.getCurrentIssueType(), this.getTargetIssueType())) {
            changeHolder.addChangeItem(new ChangeItemBean("jira", "Workflow", originalWfId, this.getWorkflowManager().getWorkflow(this.getIssue()).getName(), newIssue.getWorkflowId().toString(), this.getWorkflowForType(this.getTargetPid(), this.getTargetIssueType()).getName()));
            if (!this.isStatusMatch()) {
                changeHolder.addChangeItem(new ChangeItemBean("jira", "status", this.getCurrentStatus().getId(), this.getCurrentStatus().getName(), this.getTargetStatus().getId(), this.getTargetStatus().getName()));
            }
        }
        newIssue.store();
        Map modifiedFields = newIssue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.getFieldManager().isOrderableField(fieldId)) continue;
            OrderableField field = this.getFieldManager().getOrderableField(fieldId);
            FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout((Issue)newIssue).getFieldLayoutItem(field);
            field.updateValue(fieldLayoutItem, (Issue)newIssue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)changeHolder);
        }
        newIssue.resetModifiedFields();
        return changeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSubTasks(Issue parentIssue) throws GenericEntityException, FieldValidationException, WorkflowException {
        Collection subTasks = parentIssue.getSubTaskObjects();
        for (Issue originalSubTask : subTasks) {
            MutableIssue targetSubTask = this.getIssueManager().getIssueObject(originalSubTask.getId());
            ArrayList<ChangeItemBean> subTaskChangeItems = new ArrayList<ChangeItemBean>();
            String issueTypeKey = this.getPrefixIssueTypeId(originalSubTask.getIssueTypeId());
            if (this.getMoveIssueBean().getFieldValuesHolder().containsKey(issueTypeKey)) {
                String newIssueType = (String)this.getMoveIssueBean().getFieldValuesHolder().get(issueTypeKey);
                targetSubTask.setIssueTypeId(newIssueType);
            }
            Transaction txn = Txn.begin();
            if (!this.getProjectObject().equals(this.getTargetProjectObj())) {
                Project project = this.getTargetProjectObj();
                targetSubTask.setProjectObject(project);
                long incCount = this.getProjectManager().getNextId(project);
                targetSubTask.setNumber(Long.valueOf(incCount));
                this.attachmentManager.moveAttachments(originalSubTask, targetSubTask.getKey());
                this.issueManager.recordMovedIssueKey(originalSubTask);
            }
            GenericValue subTaskUpdateLog = null;
            try {
                if (!this.isWorkflowMatch(originalSubTask.getIssueTypeId(), targetSubTask.getIssueTypeId())) {
                    List subTaskMigrationItems = this.migrateSubTask(originalSubTask, targetSubTask);
                    subTaskChangeItems.addAll(subTaskMigrationItems);
                }
                List subTaskDetails = this.moveSubTaskDetails(originalSubTask, targetSubTask);
                subTaskChangeItems.addAll(subTaskDetails);
                subTaskUpdateLog = ChangeLogUtils.createChangeGroup(this.getLoggedInUser(), originalSubTask, (Issue)targetSubTask, subTaskChangeItems, false);
                if (subTaskUpdateLog != null && !subTaskChangeItems.isEmpty()) {
                    targetSubTask.setUpdated(UtilDateTime.nowTimestamp());
                    targetSubTask.store();
                }
                txn.commit();
            }
            finally {
                txn.finallyRollbackIfNotCommitted();
            }
            this.dispatchSubTaskUpdateEvents(targetSubTask, subTaskUpdateLog, subTaskChangeItems);
        }
    }

    private void dispatchSubTaskUpdateEvents(MutableIssue subTask, GenericValue subTaskUpdateLog, List subTaskChangeItems) throws GenericEntityException {
        if (subTaskUpdateLog != null && !subTaskChangeItems.isEmpty()) {
            Long eventTypeId = !this.getProject().equals(this.getTargetProjectObj()) ? EventType.ISSUE_MOVED_ID : EventType.ISSUE_UPDATED_ID;
            this.issueEventManager.dispatchRedundantEvent(eventTypeId, (Issue)subTask, this.getLoggedInUser(), null, null, subTaskUpdateLog);
            ApplicationUser user = this.getLoggedInUser();
            IssueEventBundle issueEventBundle = this.issueEventBundleFactory.createIssueUpdateEventBundle((Issue)subTask, subTaskUpdateLog, IssueChangeHolderTransformer.toIssueUpdateBean(this.changeHolderWith(subTaskChangeItems), eventTypeId, user, true), user);
            this.issueEventManager.dispatchEvent(issueEventBundle);
        }
    }

    private IssueChangeHolder changeHolderWith(List changeItems) {
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        changeHolder.addChangeItems(changeItems);
        return changeHolder;
    }

    private List moveSubTaskDetails(Issue originalSubTask, MutableIssue targetSubTask) {
        DefaultIssueChangeHolder subTaskChangeHolder = new DefaultIssueChangeHolder();
        if (!this.getProjectObject().equals(this.getTargetProjectObj())) {
            OrderableField orderableField;
            subTaskChangeHolder.addChangeItem(new ChangeItemBean("jira", "Project", this.getProjectObject().getId().toString(), this.getProjectObject().getName(), this.getTargetProjectObj().getId().toString(), this.getTargetProjectObj().getName()));
            subTaskChangeHolder.addChangeItem(new ChangeItemBean("jira", "Key", null, originalSubTask.getKey(), null, targetSubTask.getKey()));
            FieldLayout targetFieldLayout = this.getTargetFieldLayout((Issue)targetSubTask);
            HashMap fieldValuesHolder = new HashMap();
            ImmutableList targetIssueTypeIdList = ImmutableList.of((Object)targetSubTask.getIssueTypeId());
            for (FieldLayoutItem fieldLayoutItem : targetFieldLayout.getVisibleLayoutItems(this.getTargetProjectObj(), (List)targetIssueTypeIdList)) {
                orderableField = fieldLayoutItem.getOrderableField();
                if ("security".equals(orderableField.getId()) || "issuetype".equals(orderableField.getId()) || !orderableField.needsMove((Collection)EasyList.build((Object)originalSubTask), (Issue)targetSubTask, fieldLayoutItem).getResult()) continue;
                orderableField.populateDefaults(fieldValuesHolder, (Issue)targetSubTask);
                orderableField.updateIssue(fieldLayoutItem, targetSubTask, fieldValuesHolder);
            }
            for (Field field : targetFieldLayout.getHiddenFields(this.getTargetProjectObj(), (List)targetIssueTypeIdList)) {
                if (!this.getFieldManager().isOrderableField(field) || !(orderableField = (OrderableField)field).hasValue((Issue)targetSubTask) || !orderableField.canRemoveValueFromIssueObject((Issue)targetSubTask)) continue;
                orderableField.removeValueFromIssueObject(targetSubTask);
            }
            targetSubTask.store();
            Map modifiedFields = targetSubTask.getModifiedFields();
            for (String fieldId : modifiedFields.keySet()) {
                if (!this.getFieldManager().isOrderableField(fieldId)) continue;
                OrderableField field = this.getFieldManager().getOrderableField(fieldId);
                FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout((Issue)targetSubTask).getFieldLayoutItem(field);
                field.updateValue(fieldLayoutItem, (Issue)targetSubTask, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)subTaskChangeHolder);
            }
            targetSubTask.resetModifiedFields();
        }
        return subTaskChangeHolder.getChangeItems();
    }

    private FieldLayout getTargetFieldLayout(Issue targetSubTask) {
        return this.getFieldLayoutManager().getFieldLayout(this.getTargetProjectObj(), targetSubTask.getIssueTypeId());
    }

    private List migrateSubTask(Issue originalSubtask, MutableIssue targetSubtask) throws GenericEntityException {
        ArrayList<ChangeItemBean> subTaskChangeItems = new ArrayList<ChangeItemBean>();
        if (!this.isTaskStatusValid(targetSubtask.getIssueTypeId(), targetSubtask.getStatusObject().getId())) {
            String subTaskTypeKey = this.getPrefixTaskStatusId(targetSubtask.getIssueTypeId(), targetSubtask.getStatusObject().getId());
            Map taskTargetStatusMap = this.getMoveIssueBean().getTaskTargetStatusHolder();
            targetSubtask.setStatusId((String)taskTargetStatusMap.get(subTaskTypeKey));
            subTaskChangeItems.add(new ChangeItemBean("jira", "status", originalSubtask.getStatusObject().getId(), originalSubtask.getStatusObject().getName(), targetSubtask.getStatusObject().getId(), targetSubtask.getStatusObject().getName()));
        }
        if (!this.isWorkflowMatch(originalSubtask.getIssueTypeId(), targetSubtask.getIssueTypeId())) {
            this.migrateIssueToWorkflow(targetSubtask, originalSubtask.getIssueTypeId(), this.getWorkflowForType(this.getTargetPid(), targetSubtask.getIssueTypeId()), targetSubtask.getStatus());
            subTaskChangeItems.add(new ChangeItemBean("jira", "Workflow", originalSubtask.getWorkflowId().toString(), this.getWorkflowManager().getWorkflow(originalSubtask.getGenericValue()).getName(), targetSubtask.getWorkflowId().toString(), this.getWorkflowForType(this.getTargetPid(), targetSubtask.getIssueTypeId()).getName()));
        }
        return subTaskChangeItems;
    }

    protected void migrateIssueToWorkflow(MutableIssue issue, String oldIssueType, JiraWorkflow targetWorkflow, Status targetStatus) throws GenericEntityException {
        if (!this.isWorkflowMatch(oldIssueType, issue.getString("type"))) {
            this.getWorkflowManager().migrateIssueToWorkflow(issue, targetWorkflow, targetStatus);
        }
    }

    public String getPrefixCustomFieldId(String key) throws GenericEntityException {
        Collection<CustomField> targetCustomFields = this.getTargetCustomFieldObjects(this.getTargetIssueType());
        for (CustomField targetCustomField : targetCustomFields) {
            if (!key.equals(targetCustomField.getName())) continue;
            return targetCustomField.getId();
        }
        return null;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Status getTargetStatus() {
        return this.getConstantsManager().getStatus(this.getTargetStatusId());
    }

    public boolean isIssueTypeMatch() throws GenericEntityException {
        return this.getCurrentIssueType().equals(this.getTargetIssueType());
    }

    public boolean isProjectMatch() throws GenericEntityException {
        return this.getProjectObject().equals(this.getTargetProjectObj());
    }

    public boolean isStatusMatch() {
        return this.getCurrentStatus().equals(this.getTargetStatus());
    }
}

