/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

@LicensedOnly
final class SelectedIssue {
    private final Getter getter;
    private GetterResult issueResult = null;

    SelectedIssue(@Nonnull Getter getter) {
        this.getter = (Getter)Preconditions.checkNotNull((Object)getter, (Object)"getter");
    }

    @Nullable
    GenericValue genericValue() {
        return this.fetchIssueResult().genericValue;
    }

    @Nullable
    Issue object() {
        return this.fetchIssueResult().object;
    }

    @Nullable
    MutableIssue mutableObject() {
        Issue issue = this.fetchIssueResult().object;
        Preconditions.checkState((issue == null || issue instanceof MutableIssue ? 1 : 0) != 0, (Object)"You didn't pass MutableIssue in the first place so you cannot get it here. This is a temporary solution before we switch everything to Issue");
        return (MutableIssue)issue;
    }

    void setObject(@Nullable Issue issueObject) {
        this.issueResult = issueObject != null ? new GetterResult(issueObject) : null;
    }

    boolean exists() {
        return this.fetchIssueResult().genericValue != null;
    }

    private GetterResult fetchIssueResult() {
        if (this.issueResult == null) {
            this.issueResult = this.getter.get();
        }
        return this.issueResult;
    }

    static final class GetterResult {
        final GenericValue genericValue;
        final Issue object;

        GetterResult(@Nullable Issue object) {
            this.object = object;
            this.genericValue = object != null ? object.getGenericValue() : null;
        }
    }

    static interface Getter {
        @Nonnull
        public GetterResult get();
    }
}

