/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.Collection;

@LicensedOnly
public class BulkChooseOperation
extends AbstractBulkOperationAction {
    private Collection<ProgressAwareBulkOperation> bulkOperations;
    private String operation;
    final BulkOperationManager bulkOperationManager;

    public BulkChooseOperation(SearchService searchService, BulkOperationManager bulkOperationManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper) {
        super(searchService, bulkEditBeanSessionHelper);
        this.bulkOperationManager = bulkOperationManager;
        this.bulkOperations = bulkOperationManager.getProgressAwareBulkOperations();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkEditBean().addAvailablePreviousStep(1);
        this.getBulkEditBean().setCurrentStep(2);
        return this.getResult();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getOperation())) {
            this.addErrorMessage(this.getText("bulk.chooseoperation.chooseoperation.error"));
        } else {
            if (!this.bulkOperationManager.isValidOperation(this.getOperation())) {
                this.addErrorMessage(this.getText("bulk.chosseoperation.invalid.operation"));
            }
            if ("BulkMove".equals(this.getOperation()) && this.getBulkEditBean() != null && this.getBulkEditBean().isOnlyContainsSubTasks()) {
                this.addErrorMessage(this.getText("admin.errors.issuebulkedit.cannot.move.sub.tasks"));
            }
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        String operationName = this.bulkOperationManager.getProgressAwareOperation(this.getOperation()).getOperationName();
        if (this.getBulkEditBean() != null) {
            if (operationName != null && Arrays.asList("BulkMove", "BulkWorkflowTransition", "BulkEdit", "BulkDelete", "BulkWatch", "BulkUnwatch", "BulkArchive").contains(operationName)) {
                this.getBulkEditBean().setOperationName(operationName);
            }
        } else {
            return this.redirectToStart();
        }
        return this.getRedirect(operationName + "Details.jspa");
    }

    public Collection<ProgressAwareBulkOperation> getBulkOperations() {
        return this.bulkOperations;
    }

    public boolean isCanPerform(ProgressAwareBulkOperation bulkOperation) throws Exception {
        return bulkOperation.canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public boolean isHasAvailableOperations() throws Exception {
        for (ProgressAwareBulkOperation bulkOperation : this.bulkOperations) {
            if (!this.isCanPerform(bulkOperation)) continue;
            return true;
        }
        return false;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

