/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.monitoring;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.monitoring.AppMonitoringMetricsService;
import com.atlassian.jira.monitoring.IpdMonitoringControlService;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@WebSudoRequired
@AdminOnly
public class JmxMonitoringAction
extends JiraWebActionSupport {
    private final AppMonitoringMetricsService appMonitoringMetricsService;
    private final JmxMetricsExposer jmxMetricsExposer;
    private final PageBuilderService pageBuilder;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final IpdMonitoringControlService ipdMonitoringControlService;

    public JmxMonitoringAction(AppMonitoringMetricsService appMonitoringMetricsService, JmxMetricsExposer jmxMetricsExposer, PageBuilderService pageBuilder, DynamicWebInterfaceManager webInterfaceManager, IpdMonitoringControlService ipdMonitoringControlService) {
        this.appMonitoringMetricsService = appMonitoringMetricsService;
        this.jmxMetricsExposer = jmxMetricsExposer;
        this.pageBuilder = pageBuilder;
        this.webInterfaceManager = webInterfaceManager;
        this.ipdMonitoringControlService = ipdMonitoringControlService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:jmx-monitoring-resources");
        return "success";
    }

    @ActionViewData(value="success")
    public Map<String, Object> getData() {
        return MapBuilder.newBuilder().add((Object)"jmxMonitoringEnabled", (Object)this.jmxMetricsExposer.isJmxEnabled()).add((Object)"appMonitoringEnabled", (Object)this.appMonitoringMetricsService.isAppMonitoringEnabled()).add((Object)"ipdMonitoringEnabled", (Object)this.ipdMonitoringControlService.isIpdMonitoringEnabled()).add((Object)"extensionContent", (Object)this.renderPanel("atl.admin.monitoring")).add((Object)"metrics", (Object)this.jmxMetricsExposer.getExposedMetricNames()).toMap();
    }

    private String renderPanel(String location) {
        return (String)SafePluginPointAccess.call(() -> String.join((CharSequence)"", SafePluginPointAccess.to().modules((Iterable)this.webInterfaceManager.getDisplayableWebPanels(location, (Map)ImmutableMap.of()), (descriptor, webPanel) -> webPanel.getHtml((Map)ImmutableMap.of())))).getOrElse((Object)"");
    }
}

