/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectService;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import javax.servlet.http.HttpSession;

@WebSudoRequired
@AdminOnly
public class ArchiveProject
extends IssueActionSupport {
    private boolean confirm;
    private Long pid;
    private Project project;
    private final ArchivedProjectService projectService;
    private final HelpUrls helpUrls;

    public ArchiveProject(IssueManager issueManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, ProjectManager projectManager, PermissionManager permissionManager, VersionManager versionManager, ArchivedProjectService projectService, UserIssueHistoryManager userHistoryManager, TimeTrackingConfiguration timeTrackingConfiguration, HelpUrls helpUrls) {
        super(issueManager, customFieldManager, attachmentManager, projectManager, permissionManager, versionManager, userHistoryManager, timeTrackingConfiguration);
        this.projectService = projectService;
        this.helpUrls = helpUrls;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        Project projectObject = this.getProject();
        if (projectObject == null) {
            this.addErrorMessage(this.getText("admin.archiveproject.error.no.project", this.pid));
            return;
        }
        ArchivedProjectService.ValidationResult result = this.projectService.validateArchiveProject(this.getLoggedInUser(), projectObject.getKey());
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm) {
            ArchivedProjectService.ValidationResult result = this.projectService.validateArchiveProject(this.getLoggedInUser(), this.getProject().getKey());
            if (!result.isValid()) {
                this.addErrorCollection(result.getErrorCollection());
                return "error";
            }
            ArchivedProjectService.ArchivingResult archivingResult = this.projectService.archiveProject(result);
            if (!archivingResult.isValid()) {
                this.addErrorCollection(archivingResult.getErrorCollection());
                return "error";
            }
            HttpSession session = this.getHttpRequest().getSession();
            session.removeAttribute("atl.jira.admin.current.project");
            if (this.isInlineDialogMode()) {
                return this.returnMsgToUser(null, this.getI18nHelper().getText("admin.archiveproject.success.flag"), JiraWebActionSupport.MessageType.SUCCESS, true, null);
            }
            return this.getRedirect(this.getDestinationURL());
        }
        return this.getResult();
    }

    @ActionViewData
    public String getKey() {
        return this.project != null ? this.project.getKey() : "";
    }

    @ActionViewData
    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProjectObj(this.pid);
        }
        return this.project;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    @ActionViewData
    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ActionViewData
    public String getDestinationURL() {
        return "BrowseProjects.jspa?s=view_projects";
    }

    @ActionViewData
    public HelpUrl getDocumentationUrl() {
        return this.helpUrls.getUrl("project.archive");
    }

    @ActionViewData
    public String getXsrfToken() {
        return super.getXsrfToken();
    }

    @ActionViewData(key="errorMessages")
    public Collection<String> getFlushedErrorMessages() {
        return super.getFlushedErrorMessages();
    }
}

