/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.project.DeleteProjectTaskContext;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@AdminOnly
public class DeleteProject
extends IssueActionSupport {
    private boolean confirm;
    private Long pid;
    private final ProjectService projectService;
    private Project project;
    private Long taskId;
    private final TaskManager taskManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private String destinationURL;
    private static String projectListURL = "/secure/project/BrowseProjects.jspa?s=view_projects";
    private TaskDescriptor<ProjectService.DeleteProjectResult> currentTaskDescriptor;
    private TaskDescriptorBean<ProjectService.DeleteProjectResult> currentTask;

    public DeleteProject(IssueManager issueManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, ProjectManager projectManager, PermissionManager permissionManager, VersionManager versionManager, ProjectService projectService, UserIssueHistoryManager userHistoryManager, TimeTrackingConfiguration timeTrackingConfiguration, TaskManager taskManager, TaskDescriptorBean.Factory taskBeanFactory) {
        super(issueManager, customFieldManager, attachmentManager, projectManager, permissionManager, versionManager, userHistoryManager, timeTrackingConfiguration);
        this.projectService = projectService;
        this.taskManager = taskManager;
        this.taskBeanFactory = taskBeanFactory;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.setDestinationURL(StringUtils.isNotBlank((CharSequence)this.getReturnUrl()) ? this.getReturnUrl() : projectListURL);
        this.setReturnUrl(null);
        TaskDescriptor<ProjectService.DeleteProjectResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        return super.doDefault();
    }

    protected void doValidation() {
        Project projectObject = this.getProject();
        if (projectObject == null) {
            this.addErrorMessage(this.getText("admin.deleteproject.error.no.project", this.pid));
            return;
        }
        ProjectService.DeleteProjectValidationResult result = this.projectService.validateDeleteProject(this.getLoggedInUser(), projectObject.getKey());
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.setDestinationURL(StringUtils.isNotBlank((CharSequence)this.getReturnUrl()) ? this.getReturnUrl() : projectListURL);
            this.setReturnUrl(null);
            TaskDescriptor<ProjectService.DeleteProjectResult> taskDescriptor = this.getCurrentTaskDescriptor();
            if (taskDescriptor != null) {
                return this.getRedirect(taskDescriptor.getProgressURL());
            }
            ProjectService.DeleteProjectValidationResult result = this.projectService.validateDeleteProject(this.getLoggedInUser(), this.getProject().getKey());
            if (!result.isValid()) {
                this.addErrorCollection(result.getErrorCollection());
                return "error";
            }
            ProjectService.DeleteProjectResult deleteResult = this.projectService.deleteProjectAsynchronous(this.getLoggedInUser(), result);
            if (!deleteResult.isValid()) {
                this.addErrorCollection(deleteResult.getErrorCollection());
                return "error";
            }
            HttpSession session = this.getHttpRequest().getSession();
            session.removeAttribute("atl.jira.admin.current.project");
            return this.getRedirect(deleteResult.getRedirectUrl() + "&destinationURL=" + this.getDestinationURL());
        }
        return this.getResult();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doProgress() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("common.tasks.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("common.tasks.task.not.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof DeleteProjectTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", DeleteProjectTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        if (this.currentTaskDescriptor.isFinished() && !this.currentTaskDescriptor.isCancelled()) {
            ProjectService.DeleteProjectResult result = this.currentTaskDescriptor.getResult();
            this.addErrorCollection(result.getErrorCollection());
        }
        return "progress";
    }

    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProjectObj(this.pid);
        }
        return this.project;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public void setDestinationURL(String destinationURL) {
        this.destinationURL = destinationURL;
    }

    public TaskDescriptorBean<ProjectService.DeleteProjectResult> getCurrentTask() {
        TaskDescriptor<ProjectService.DeleteProjectResult> taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.getCurrentTaskDescriptor()) != null) {
            this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.currentTask;
    }

    private TaskDescriptor<ProjectService.DeleteProjectResult> getCurrentTaskDescriptor() {
        Project project;
        if (this.currentTaskDescriptor == null && (project = this.getProject()) != null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new DeleteProjectTaskContext(project));
        }
        return this.currentTaskDescriptor;
    }
}

