/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
@AdminOnly
public class ProjectEmail
extends JiraWebActionSupport {
    private final ProjectManager projectManager;
    private final MailServerManager mailServerManager;
    private long projectId;
    private String fromAddress;
    private Project project;

    public ProjectEmail(ProjectManager projectManager, MailServerManager mailServerManager) {
        this.projectManager = projectManager;
        this.mailServerManager = mailServerManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        SMTPMailServer defaultSMTPMailServer;
        this.fromAddress = this.getProject().getEmail();
        if (this.fromAddress == null && (defaultSMTPMailServer = this.mailServerManager.getDefaultSMTPMailServer()) != null) {
            this.fromAddress = defaultSMTPMailServer.getDefaultFrom();
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (TextUtils.stringSet((String)this.getFromAddress()) && !TextUtils.verifyEmail((String)this.getFromAddress())) {
            this.addError("fromAddress", this.getText("admin.errors.projectemail.enter.valid.address"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        PropertySet ps = this.getPropertySet();
        if (StringUtils.isBlank((CharSequence)this.fromAddress)) {
            if (ps.exists("jira.project.email.sender")) {
                ps.remove("jira.project.email.sender");
            }
        } else {
            ps.setString("jira.project.email.sender", this.fromAddress);
        }
        return this.returnComplete(this.createRedirectUrl());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doReset() throws Exception {
        PropertySet ps = this.getPropertySet();
        if (ps.exists("jira.project.email.sender")) {
            ps.remove("jira.project.email.sender");
        }
        return this.returnComplete(this.createRedirectUrl());
    }

    private String createRedirectUrl() {
        if (StringUtils.isBlank((CharSequence)this.getReturnUrl())) {
            return String.format("/plugins/servlet/project-config/%s", this.getProjectKey());
        }
        return this.getReturnUrl();
    }

    private PropertySet getPropertySet() throws GenericEntityException {
        return OFBizPropertyUtils.getPropertySet(this.getProject().getGenericValue());
    }

    public String getProjectKey() {
        return this.getProject().getKey();
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    private Project getProject() {
        if (this.project == null) {
            this.project = this.projectManager.getProjectObj(Long.valueOf(this.projectId));
            if (this.project == null) {
                throw new IllegalArgumentException("Project not found for projectId " + this.projectId);
            }
        }
        return this.project;
    }
}

