/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.projectcategory;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
@AdminOnly
public class DeleteProjectCategory
extends ProjectActionSupport {
    private boolean confirm = false;
    private Long id;

    public DeleteProjectCategory(ProjectManager projectManager, PermissionManager permissionManager) {
        super(projectManager, permissionManager);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (!this.isConfirm()) {
            this.addErrorMessage(this.getText("admin.errors.projectcategory.must.confirm.delete"));
        }
        if (null == this.getId() || null == this.projectManager.getProjectCategoryObject(this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.projectcategory.must.specify.category"));
        } else {
            Collection<Project> projectsFromProjectCategory = this.getProjects();
            if (null != projectsFromProjectCategory && !projectsFromProjectCategory.isEmpty()) {
                this.addErrorMessage(this.getText("admin.errors.projectcategory.currently.projects.linked"));
            }
        }
    }

    private Collection<Project> getProjects() {
        return this.projectManager.getProjectsFromProjectCategory(this.getProjectCategory());
    }

    private ProjectCategory getProjectCategory() {
        return this.projectManager.getProjectCategoryObject(this.getId());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.projectManager.removeProjectCategory(this.getId());
        return this.getRedirect("ViewProjectCategories!default.jspa");
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

