/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.renderers.wiki;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.plugin.contentlinkresolver.ContentLinkResolverDescriptor;
import com.atlassian.jira.plugin.renderer.MacroModuleDescriptor;
import com.atlassian.jira.plugin.renderercomponent.RendererComponentFactoryDescriptor;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@LicensedOnly
public class WikiRendererHelpAction
extends JiraWebActionSupport {
    private String section;
    private PluginAccessor pluginAccessor;
    private HashMap macrosWithHelpBySection;
    private ArrayList macrosWithHelpNoSection;
    private HashMap contentLinksWithHelpBySection;
    private ArrayList contentLinksWithHelpNoSection;
    private HashMap rendererComponentFactoriesWithHelpBySection;
    private ArrayList rendererComponentFactoriesWithHelpNoSection;

    public WikiRendererHelpAction(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return "success";
    }

    public String getSection() {
        if (this.section == null) {
            return "index";
        }
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public Collection getMacroHelpForSection(String section) {
        if (this.macrosWithHelpBySection == null) {
            this.loadMacroHelp();
        }
        return (Collection)this.macrosWithHelpBySection.get(section);
    }

    public Collection getMacroHelpNoSection() {
        if (this.macrosWithHelpNoSection == null) {
            this.loadMacroHelp();
        }
        return this.macrosWithHelpNoSection;
    }

    public Collection getContentLinkHelpForSection(String section) {
        if (this.contentLinksWithHelpBySection == null) {
            this.loadContentLinkHelp();
        }
        return (Collection)this.contentLinksWithHelpBySection.get(section);
    }

    public Collection getContentLinkHelpNoSection() {
        if (this.contentLinksWithHelpNoSection == null) {
            this.loadContentLinkHelp();
        }
        return this.contentLinksWithHelpNoSection;
    }

    public Collection getRendererComponentFactoriesHelpForSection(String section) {
        if (this.rendererComponentFactoriesWithHelpBySection == null) {
            this.loadRendererComponentFactoriesHelp();
        }
        return (Collection)this.rendererComponentFactoriesWithHelpBySection.get(section);
    }

    public Collection getRendererComponentFactoriesHelpNoSection() {
        if (this.rendererComponentFactoriesWithHelpNoSection == null) {
            this.loadRendererComponentFactoriesHelp();
        }
        return this.rendererComponentFactoriesWithHelpNoSection;
    }

    private void loadMacroHelp() {
        List macroDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(MacroModuleDescriptor.class);
        this.macrosWithHelpBySection = Maps.newHashMapWithExpectedSize((int)macroDescriptors.size());
        this.macrosWithHelpNoSection = Lists.newArrayListWithCapacity((int)macroDescriptors.size());
        for (MacroModuleDescriptor descriptor : macroDescriptors) {
            if (!descriptor.hasHelp()) continue;
            if (descriptor.getHelpSection() == null) {
                this.macrosWithHelpNoSection.add(descriptor);
                continue;
            }
            ArrayList<MacroModuleDescriptor> list = (ArrayList<MacroModuleDescriptor>)this.macrosWithHelpBySection.get(descriptor.getHelpSection());
            if (list == null) {
                list = new ArrayList<MacroModuleDescriptor>();
            }
            list.add(descriptor);
            this.macrosWithHelpBySection.put(descriptor.getHelpSection(), list);
        }
    }

    private void loadContentLinkHelp() {
        List contentLinkDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ContentLinkResolverDescriptor.class);
        this.contentLinksWithHelpBySection = Maps.newHashMapWithExpectedSize((int)contentLinkDescriptors.size());
        this.contentLinksWithHelpNoSection = Lists.newArrayListWithCapacity((int)contentLinkDescriptors.size());
        for (ContentLinkResolverDescriptor descriptor : contentLinkDescriptors) {
            if (!descriptor.hasHelp()) continue;
            if (descriptor.getHelpSection() == null) {
                this.contentLinksWithHelpNoSection.add(descriptor);
                continue;
            }
            ArrayList<ContentLinkResolverDescriptor> list = (ArrayList<ContentLinkResolverDescriptor>)this.contentLinksWithHelpBySection.get(descriptor.getHelpSection());
            if (list == null) {
                list = new ArrayList<ContentLinkResolverDescriptor>();
            }
            list.add(descriptor);
            this.contentLinksWithHelpBySection.put(descriptor.getHelpSection(), list);
        }
    }

    private void loadRendererComponentFactoriesHelp() {
        this.rendererComponentFactoriesWithHelpBySection = new HashMap();
        this.rendererComponentFactoriesWithHelpNoSection = new ArrayList();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(RendererComponentFactoryDescriptor.class);
        for (RendererComponentFactoryDescriptor descriptor : descriptors) {
            if (!descriptor.hasHelp()) continue;
            if (descriptor.getHelpSection() == null) {
                this.rendererComponentFactoriesWithHelpNoSection.add(descriptor);
                continue;
            }
            ArrayList<RendererComponentFactoryDescriptor> list = (ArrayList<RendererComponentFactoryDescriptor>)this.rendererComponentFactoriesWithHelpBySection.get(descriptor.getHelpSection());
            if (list == null) {
                list = new ArrayList<RendererComponentFactoryDescriptor>();
            }
            list.add(descriptor);
            this.rendererComponentFactoriesWithHelpBySection.put(descriptor.getHelpSection(), list);
        }
    }
}

