/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.jira.web.action.issue.URLUtil;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;

public class PostSetupURIProvider {
    private static Logger log = Logger.getLogger(PostSetupURIProvider.class);
    private final ApplicationManager applicationManager;

    public PostSetupURIProvider(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public String getPostSetupRedirect(Option<String> origin) throws URISyntaxException {
        Option<Application> applicationWithPostInstall = this.getApplicationWithPostInstall();
        Option postInstallUri = applicationWithPostInstall.flatMap((Function)new Function<Application, Option<URI>>(){

            @Override
            public Option<URI> apply(Application input) {
                return Option.option((Object)((URI)input.getPostInstallURI().getOrNull()));
            }
        });
        final String rawUri = ((URI)postInstallUri.getOrElse((Object)this.getDefaultPostSetupURI())).toASCIIString();
        String redirectWithOrigin = (String)origin.fold(Suppliers.ofInstance((Object)rawUri), (Function)new Function<String, String>(){

            @Override
            public String apply(String input) {
                return PostSetupURIProvider.this.addParameterToURI(rawUri, input);
            }
        });
        return redirectWithOrigin;
    }

    private String addParameterToURI(String rawUri, String input) {
        try {
            return URLUtil.addRequestParameter(rawUri, "src=" + URIUtil.encodeQuery((String)input));
        }
        catch (URIException e) {
            return rawUri;
        }
    }

    private URI getDefaultPostSetupURI() throws URISyntaxException {
        return new URI("Dashboard.jspa");
    }

    private Option<Application> getApplicationWithPostInstall() {
        Option applications = Option.option((Object)this.applicationManager.getApplications());
        return applications.flatMap((Function)new Function<Iterable<Application>, Option<? extends Application>>(){

            @Override
            public Option<Application> apply(Iterable<Application> applications) {
                return Iterables.findFirst(applications, (Predicate)new Predicate<Application>(){

                    @Override
                    public boolean test(Application input) {
                        boolean isPlatform = input instanceof PlatformApplication;
                        boolean hasPostInstallStep = input.getPostInstallURI().isDefined();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Application %s(%s), isPlatform %b, postInstallStep: %s", input.getName(), input.getKey(), isPlatform, input.getPostInstallURI()));
                        }
                        return !isPlatform && hasPostInstallStep;
                    }
                });
            }
        });
    }
}

