/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.internal.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.internal.db.DatabaseList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.MySQL8ConfigurationChecker;
import com.atlassian.jira.config.database.MySQL8VersionPredicate;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.startup.DatabaseInitialImporter;
import com.atlassian.jira.startup.FaultDescription;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;

@UnrestrictedAccess
public class SetupDatabase
extends AbstractSetupAction {
    public static final String REDIRECT_URL = "SetupDatabase!default.jspa";
    private final BuildUtilsInfo buildUtilsInfo;
    private final DatabaseConfigurationManager databaseConfigurationManager;
    private final VelocityTemplatingEngine velocityEngine;
    private final DatabaseInitialImporter databaseInitialImporter;
    private final HelpUrls helpUrls;
    private String databaseOption = "internal";
    private String importOption = "none";
    private String databaseType;
    private String schemaName;
    private static final Map<String, String> SCHEMA_NAMES = ImmutableMap.of((Object)"postgres72", (Object)"public", (Object)"mssql", (Object)"dbo", (Object)"postgresaurora96", (Object)"public");
    private String jdbcHostname;
    private String jdbcPort;
    private String jdbcDatabase;
    private String jdbcSid;
    private String jdbcUsername;
    private String jdbcPassword;
    private String localeForTexts;
    private String jiraLanguage;
    private final DatabaseList databaseList = new DatabaseList();
    private boolean isTestConnectionSuccessful;
    @VisibleForTesting
    static final Map<String, DatabaseType> databaseTypeMap = MapBuilder.newBuilder().add((Object)DatabaseType.ORACLE.getTypeName(), (Object)DatabaseType.ORACLE).add((Object)DatabaseType.POSTGRES.getTypeName(), (Object)DatabaseType.POSTGRES).add((Object)DatabaseType.AURORA_POSTGRES.getTypeName(), (Object)DatabaseType.AURORA_POSTGRES).add((Object)DatabaseType.MY_SQL8.getTypeName(), (Object)DatabaseType.MY_SQL8).add((Object)DatabaseType.SQL_SERVER.getTypeName(), (Object)DatabaseType.SQL_SERVER).toMap();

    public SetupDatabase(FileFactory fileFactory, BuildUtilsInfo buildUtilsInfo, DatabaseConfigurationManager databaseConfigurationManager, VelocityTemplatingEngine velocityEngine, DatabaseInitialImporter databaseInitialImporter, HelpUrls helpUrls, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.buildUtilsInfo = buildUtilsInfo;
        this.databaseConfigurationManager = databaseConfigurationManager;
        this.velocityEngine = velocityEngine;
        this.databaseInitialImporter = databaseInitialImporter;
        this.helpUrls = helpUrls;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doInput() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SupportedMethods(value={RequestMethod.GET})
    public String doConnectionCheck() throws IOException {
        HttpServletResponse response = this.getHttpResponse();
        JSONObject json = new JSONObject();
        response.setContentType("application/json");
        this.databaseOption = "external";
        this.doValidation();
        try {
            json.put("data", this.getSoyDataForConnectionCheck());
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            response.getWriter().write("{}");
        }
        finally {
            response.getWriter().flush();
        }
        return "none";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        if (this.isDatabaseSetup()) {
            this.databaseInitialImporter.importInitialData(this.getLoggedInUser(), true);
            return this.forceRedirect("SetupApplicationProperties!default.jspa");
        }
        this.setIndexingLanguageForDefaultServerLocale();
        return "input";
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        if (this.isExternalDatabase()) {
            if ("".equals(this.databaseType) || this.databaseType == null) {
                this.addError("databaseType", this.getText("setupdb.error.selectDatabaseType"));
            }
            if (StringUtils.isEmpty((CharSequence)this.jdbcHostname)) {
                this.addError("jdbcHostname", this.getText("setupdb.error.requireJdbcHostname"));
            }
            if (StringUtils.isEmpty((CharSequence)this.jdbcPort)) {
                this.addError("jdbcPort", this.getText("setupdb.error.requireJdbcPort"));
            }
            if (this.isOracleDatabaseType()) {
                if (StringUtils.isEmpty((CharSequence)this.jdbcSid)) {
                    this.addError("jdbcSid", this.getText("setupdb.error.requireSID"));
                }
            } else if (StringUtils.isEmpty((CharSequence)this.jdbcDatabase)) {
                this.addError("jdbcDatabase", this.getText("setupdb.error.requireDatabase"));
            }
            if (StringUtils.isEmpty((CharSequence)this.jdbcUsername)) {
                this.addError("jdbcUsername", this.getText("setupdb.error.requireJdbcUsername"));
            }
        }
        this.testConnection();
        this.validateDatabaseIsEmpty();
        super.doValidation();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        String locale = this.getLocale().toString();
        if (!this.isDatabaseSetup()) {
            DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
            this.databaseConfigurationManager.setDatabaseConfiguration(databaseConfiguration);
            this.databaseConfigurationManager.activateDatabase();
        }
        this.databaseInitialImporter.importInitialData(this.getLoggedInUser());
        this.setJiraLocale(locale);
        this.setIndexingLanguageForDefaultServerLocale();
        return this.forceRedirect("SetupApplicationProperties!default.jspa");
    }

    private void testConnection() {
        if (!this.hasAnyErrors()) {
            try {
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                FaultDescription startupCheck = databaseConfiguration.testConnection((AtlassianBootstrapManager)new DefaultAtlassianBootstrapManager());
                if (startupCheck != null) {
                    this.addErrorMessage(startupCheck.getFaultDescription());
                }
            }
            catch (BootstrapException e) {
                this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                Throwable cause = e.getCause();
                this.addErrorMessage(cause.getLocalizedMessage());
                if (cause.getCause() != null && !cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) {
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            catch (InvalidDatabaseDriverException e) {
                this.addErrorMessage(this.getText("setupdb.error.invalidDriver", e.driverClassName()));
            }
            this.isTestConnectionSuccessful = !this.hasAnyErrors();
        }
    }

    private void validateDatabaseIsEmpty() {
        if (!this.hasAnyErrors()) {
            boolean isMySQL8ConfigurationCorrect;
            boolean isMySQL8VersionCorrect;
            boolean isDatabaseEmpty;
            block13: {
                isDatabaseEmpty = false;
                isMySQL8VersionCorrect = true;
                isMySQL8ConfigurationCorrect = true;
                DatabaseConfig databaseConfiguration = this.createDatabaseConfiguration();
                DefaultAtlassianBootstrapManager bootstrapManager = new DefaultAtlassianBootstrapManager();
                try (Connection conn = databaseConfiguration.getDatasource().getConnection((AtlassianBootstrapManager)bootstrapManager);){
                    isDatabaseEmpty = databaseConfiguration.isDatabaseEmpty((AtlassianBootstrapManager)bootstrapManager);
                    if ("mysql8".equals(databaseConfiguration.getDatabaseType())) {
                        isMySQL8VersionCorrect = new MySQL8VersionPredicate().test(conn);
                        isMySQL8ConfigurationCorrect = new MySQL8ConfigurationChecker().test(conn);
                    }
                }
                catch (BootstrapException | SQLException e) {
                    this.addErrorMessage(this.getText("setupdb.error.connectionFailed"));
                    Throwable cause = e.getCause();
                    this.addErrorMessage(cause.getLocalizedMessage());
                    if (cause.getCause() == null || cause.getLocalizedMessage().equals(cause.getCause().getLocalizedMessage())) break block13;
                    this.addErrorMessage(cause.getCause().getLocalizedMessage());
                }
            }
            if (!isDatabaseEmpty) {
                this.addErrorMessage(this.getText("setupdb.error.nonemptyDatabase.with.upgrade.documentation", this.getHelpPaths().get("upgrade")));
            }
            if (!isMySQL8VersionCorrect) {
                this.addErrorMessage(this.getText("setupdb.error.mysqlVersion8.not.compatible.with.instance", this.getHelpPaths().get("upgrade")));
            }
            if (!isMySQL8ConfigurationCorrect) {
                this.addErrorMessage(this.getText("setupdb.error.mysqlVersion8.wrong.default.configuration", this.getHelpPaths().get("upgrade")));
            }
            this.isTestConnectionSuccessful = !this.hasAnyErrors();
        }
    }

    private DatabaseConfig createDatabaseConfiguration() {
        if (this.isExternalDatabase()) {
            DatabaseDetails databaseDetails = this.getDatabaseDetails(this.databaseType);
            int poolSize = databaseDetails.getPoolSize();
            String instanceName = this.isOracleDatabaseType() ? this.jdbcSid : this.jdbcDatabase;
            DatabaseType type = this.getDatabaseTypeEnum();
            ConnectionPoolInfo.Builder connectionPoolInfoBuilder = ConnectionPoolInfo.builder();
            connectionPoolInfoBuilder.setPoolMaxSize(Integer.valueOf(poolSize)).setPoolMaxWait(Long.valueOf(30000L)).setPoolMinSize(Integer.valueOf(poolSize)).setRemoveAbandonedOnBorrow(Boolean.valueOf(true)).setRemoveAbandonedTimeout(Integer.valueOf(300)).setTestWhileIdle(Boolean.valueOf(true)).setTestOnBorrow(Boolean.valueOf(false)).setMinEvictableTimeMillis(Long.valueOf(60000L)).setTimeBetweenEvictionRunsMillis(Long.valueOf(300000L));
            if (type.isMySQLCompatible().booleanValue()) {
                connectionPoolInfoBuilder.setValidationQuery("select 1");
                connectionPoolInfoBuilder.setValidationQueryTimeout(Integer.valueOf(3));
            }
            if (type == DatabaseType.SQL_SERVER || type.isPostgreSQlCompatible().booleanValue()) {
                connectionPoolInfoBuilder.setValidationQuery("select 1");
            }
            if (type == DatabaseType.ORACLE) {
                connectionPoolInfoBuilder.setValidationQuery("select 1 from dual");
            }
            JdbcDatasource.Builder builder = JdbcDatasource.builder().setDatabaseType(type).setHostname(this.jdbcHostname).setPort(this.jdbcPort).setInstance(instanceName).setUsername(this.jdbcUsername).setPassword(this.jdbcPassword).setConnectionPoolInfo(connectionPoolInfoBuilder.build());
            JdbcDatasource datasource = builder.build();
            return new DatabaseConfig(this.databaseType, this.schemaName, datasource);
        }
        return this.databaseConfigurationManager.getInternalDatabaseConfiguration();
    }

    @ActionViewData
    public List<Map<String, Object>> getImportOptions() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutableMap.of((Object)"id", (Object)"jira-setup-database-field-import-none", (Object)"isChecked", (Object)"none".equals(this.getImportOption()), (Object)"labelText", (Object)this.getText("setupdb.import.none"), (Object)"value", (Object)"none"));
        builder.add((Object)ImmutableMap.of((Object)"id", (Object)"jira-setup-database-field-import-import", (Object)"isChecked", (Object)"import".equals(this.getImportOption()), (Object)"labelText", (Object)this.getText("setupdb.import.import"), (Object)"value", (Object)"import"));
        return builder.build();
    }

    private Map<String, String> getHelpPaths() {
        return ImmutableMap.of((Object)"connecting", (Object)this.helpUrls.getUrl("dbconfig.index").getUrl(), (Object)"external", (Object)this.helpUrls.getUrl("dbconfig.index").getUrl(), (Object)"migration", (Object)this.helpUrls.getUrl("dbconfig.switchdbs").getUrl(), (Object)"upgrade", (Object)this.helpUrls.getUrl("dbconfig.upgrade.instructions").getUrl());
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getSoyData() {
        Map errors = this.getErrors();
        ImmutableMap.Builder errorsTransformed = ImmutableMap.builder();
        for (Map.Entry entry : errors.entrySet()) {
            errorsTransformed.put((Object)((String)entry.getKey()), (Object)ImmutableList.of((Object)((String)entry.getValue())));
        }
        return ImmutableMap.builder().put((Object)"databaseMessagesContent", this.getDatabaseMessages()).put((Object)"errors", (Object)errorsTransformed.build()).put((Object)"globalErrors", (Object)this.getErrorMessages()).put((Object)"fieldValues", this.getFieldValues()).put((Object)"helpPaths", this.getHelpPaths()).build();
    }

    public Map<String, Object> getSoyDataForConnectionCheck() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.getSoyData());
        builder.put((Object)"externalDatabases", this.getExternalDatabases());
        builder.put((Object)"dbTestSuccessful", (Object)this.getDbTestSuccessful());
        return builder.build();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doGetInstalledLocales() throws JSONException, IOException {
        HttpServletResponse response = this.getHttpResponse();
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        Set installedLocales = localeManager.getInstalledLocales();
        JSONObject jsonObject = new JSONObject();
        JSONObject locales = new JSONObject();
        for (Locale installedLocale : installedLocales) {
            locales.put(installedLocale.toString(), (Object)installedLocale.getDisplayName(installedLocale));
        }
        jsonObject.put("currentLocale", (Object)this.getDefaultServerLanguage());
        jsonObject.put("locales", (Object)locales);
        response.setContentType("application/json");
        response.getWriter().write(jsonObject.toString());
        response.getWriter().flush();
        return "none";
    }

    @ActionViewData(key="languageDialogDefaultTexts")
    public String getLanguageTextsJson() throws JSONException {
        return this.getLanguageTextsJsonForLocale(this.getLocale());
    }

    private String getLanguageTextsJsonForLocale(Locale locale) throws JSONException {
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(locale);
        JSONObject json = new JSONObject();
        json.put("button", (Object)i18nHelper.getText("common.words.save"));
        json.put("cancel", (Object)i18nHelper.getText("common.forms.cancel"));
        json.put("connectionWarningContent", (Object)i18nHelper.getText("setup.language.dialog.connection.warning.content"));
        json.put("connectionWarningTitle", (Object)i18nHelper.getText("setup.language.dialog.connection.warning.title"));
        json.put("langLabel", (Object)i18nHelper.getText("setup.choose.language"));
        json.put("langDesc", (Object)i18nHelper.getText("setupdb.server.language.description"));
        json.put("header", (Object)i18nHelper.getText("setup.language.dialog.header"));
        return json.toString();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doGetLanguageTexts() throws JSONException, IOException {
        HttpServletResponse response = this.getHttpResponse();
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        Locale locale = localeManager.getLocale(this.localeForTexts);
        response.setContentType("application/json");
        response.getWriter().write(this.getLanguageTextsJsonForLocale(locale));
        response.getWriter().flush();
        return "none";
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doChangeLanguage() throws IOException {
        HttpServletResponse response = this.getHttpResponse();
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        localeManager.validateUserLocale(this.getLoggedInUser(), this.getJiraLanguage(), (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            this.log.warn((Object)("Invalid locale submitted (" + this.getJiraLanguage() + "), JIRA locale will not be changed"));
            response.setStatus(400);
        } else {
            this.setJiraLocale(this.getJiraLanguage());
            this.setIndexingLanguageForDefaultServerLocale();
        }
        response.setContentType("application/json");
        response.getWriter().write("{}");
        response.getWriter().flush();
        return "none";
    }

    public void setLocaleForTexts(String localeForTexts) {
        this.localeForTexts = localeForTexts;
    }

    public String getJiraLanguage() {
        return this.jiraLanguage;
    }

    public void setJiraLanguage(String jiraLanguage) {
        this.jiraLanguage = jiraLanguage;
    }

    private Map<String, String> getFieldValues() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"jdbcHostname", (Object)((String)MoreObjects.firstNonNull((Object)this.getJdbcHostname(), (Object)"")));
        builder.put((Object)"jdbcPort", (Object)((String)MoreObjects.firstNonNull((Object)this.getJdbcPort(), (Object)"")));
        builder.put((Object)"jdbcDatabase", (Object)((String)MoreObjects.firstNonNull((Object)this.getJdbcDatabase(), (Object)"")));
        builder.put((Object)"jdbcSid", (Object)((String)MoreObjects.firstNonNull((Object)this.getJdbcSid(), (Object)"")));
        builder.put((Object)"jdbcUsername", (Object)((String)MoreObjects.firstNonNull((Object)this.getJdbcUsername(), (Object)"")));
        builder.put((Object)"jdbcPassword", (Object)((String)MoreObjects.firstNonNull((Object)this.getJdbcPassword(), (Object)"")));
        builder.put((Object)"schemaName", (Object)((String)MoreObjects.firstNonNull((Object)this.getSchemaName(), (Object)"")));
        return builder.build();
    }

    @ActionViewData
    public List<Map<String, Object>> getExternalDatabases() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutableMap.of((Object)"selected", (Object)(this.databaseType == null ? 1 : 0), (Object)"text", (Object)this.getText("setupdb.database.selectType"), (Object)"value", (Object)""));
        for (DatabaseList.DatabaseType pairType : this.databaseList.getDatabases()) {
            builder.add((Object)ImmutableMap.of((Object)"selected", (Object)(this.databaseType != null && this.databaseType.equals(pairType.getKey()) ? 1 : 0), (Object)"text", (Object)pairType.getValue(), (Object)"value", (Object)pairType.getKey()));
        }
        return builder.build();
    }

    private Map<String, String> getDatabaseMessages() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, DatabaseType> databaseType : databaseTypeMap.entrySet()) {
            DatabaseDriverRegisterer registerer = DatabaseDriverRegisterer.forType(databaseType.getValue());
            if (!this.isNotShippedDriver(databaseType.getValue()) || registerer.isDriverRegistered()) continue;
            result.put((Object)databaseType.getKey(), (Object)this.createNotPresentMessage(databaseType.getValue()));
        }
        return result.build();
    }

    public DatabaseDetails getDatabaseDetails(String database) {
        try {
            return DatabaseDetails.getDefaults((String)database);
        }
        catch (ConfigurationException e) {
            this.log.debug((Object)e);
            return null;
        }
    }

    public String getDefaultServerLanguage() {
        String defaultLocale = ComponentAccessor.getApplicationProperties().getDefaultLocale().toString();
        if (this.getInstalledLocales().keySet().contains(defaultLocale)) {
            return defaultLocale;
        }
        return "en_UK";
    }

    public String getSchemaName(String database) {
        return SCHEMA_NAMES.get(database);
    }

    private ApplicationProperties getFreshApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    private boolean isNotShippedDriver(DatabaseType databaseType) {
        return EnumSet.of(DatabaseType.MY_SQL8, DatabaseType.ORACLE).contains((Object)databaseType);
    }

    private String createNotPresentMessage(DatabaseType dbType) {
        return this.getText("setupdb.database.drivernotpresent", dbType.getDisplayName(), this.getDocLink(dbType, this.getText("setupdb.database.drivernotpresent.linktext")));
    }

    private String getDocLink(DatabaseType type, String linkText) {
        HelpUrl helpPath = DatabaseDriverRegisterer.getDbConfigLink(type, this.helpUrls);
        return this.velocityEngine.render(TemplateSources.file((String)"/templates/jira/simplelink.vm")).applying((Map)ImmutableMap.of((Object)"targetUrl", (Object)helpPath.getUrl(), (Object)"title", (Object)helpPath.getTitle(), (Object)"alt", (Object)StringUtils.defaultString((String)helpPath.getAlt()), (Object)"newWindow", (Object)true, (Object)"linkText", (Object)linkText)).asHtml();
    }

    private DatabaseType getDatabaseTypeEnum() {
        DatabaseType type = databaseTypeMap.get(this.databaseType);
        if (type == null) {
            throw new IllegalStateException("Unknown database type '" + this.databaseType + "'");
        }
        return type;
    }

    private Map<String, String> getInstalledLocales() {
        Set installedLocales = ((LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class)).getInstalledLocales();
        LinkedHashMap<String, String> localeMap = new LinkedHashMap<String, String>();
        for (Locale installedLocale : installedLocales) {
            localeMap.put(installedLocale.toString(), installedLocale.getDisplayName(installedLocale));
        }
        return localeMap;
    }

    private boolean isOracleDatabaseType() {
        return "oracle10g".equals(this.databaseType);
    }

    private boolean isExternalDatabase() {
        return "external".equals(this.databaseOption);
    }

    public boolean getDbTestSuccessful() {
        return this.isTestConnectionSuccessful;
    }

    public boolean isDatabaseSetup() {
        return this.databaseConfigurationManager.isDatabaseSetup();
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseOption() {
        return this.databaseOption;
    }

    public void setDatabaseOption(String databaseOption) {
        this.databaseOption = databaseOption;
    }

    public String getImportOption() {
        return this.importOption;
    }

    public void setImportOption(String importOption) {
        this.importOption = importOption;
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public String getJdbcHostname() {
        return this.jdbcHostname;
    }

    public void setJdbcHostname(String jdbcHostname) {
        this.jdbcHostname = jdbcHostname;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcPort() {
        return this.jdbcPort;
    }

    public void setJdbcPort(String jdbcPort) {
        this.jdbcPort = jdbcPort;
    }

    public String getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    public void setJdbcDatabase(String jdbcDatabase) {
        this.jdbcDatabase = jdbcDatabase;
    }

    public String getJdbcSid() {
        return this.jdbcSid;
    }

    public void setJdbcSid(String jdbcSid) {
        this.jdbcSid = jdbcSid;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    protected String getCurrentTrackerStepId() {
        return "setup-tracker-database";
    }
}

