/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.setup.AsynchronousJiraSetupFactory;
import com.atlassian.jira.setup.InstantSetupStrategy;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.SneakyAutoLoginUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupCompleteRedirectHelper;
import com.atlassian.jira.web.action.setup.SetupSharedVariables;
import java.io.IOException;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class SetupFinishing
extends AbstractSetupAction {
    private String email;
    private String username;
    private String jiraLicense;
    private String password;
    private final SetupSharedVariables sharedVariables;
    private final SetupCompleteRedirectHelper setupCompleteRedirectHelper;

    public SetupFinishing(FileFactory fileFactory, JiraProperties jiraProperties, SetupSharedVariables sharedVariables, SetupCompleteRedirectHelper setupCompleteRedirectHelper, JiraProductInformation jiraProductInformation) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.sharedVariables = sharedVariables;
        this.setupCompleteRedirectHelper = setupCompleteRedirectHelper;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return "input";
    }

    private String getRedirectPathAfterSetup() {
        return this.getRedirectPathAfterSetup(null);
    }

    private String getRedirectPathAfterSetup(ApplicationUser user) {
        if (!this.setupAlready()) {
            return null;
        }
        return this.setupCompleteRedirectHelper.getRedirectUrl(user != null ? user : this.getLoggedInApplicationUser());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() {
        if (this.setupAlready()) {
            return this.getRedirect(this.getRedirectPathAfterSetup());
        }
        this.sharedVariables.setUserCredentials(this.email, this.username, this.password);
        this.sharedVariables.setJiraLicenseKey(this.jiraLicense);
        this.sharedVariables.setLocale(this.getLocale().toString());
        InstantSetupStrategy.setupJiraBaseUrl(JiraUrl.constructBaseUrl((HttpServletRequest)this.getHttpRequest()));
        return this.getRedirect("SetupFinishing!default.jspa");
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doTriggerSetup() throws JSONException, IOException {
        if (this.setupAlready()) {
            throw new RuntimeException("Can not be done after setup finished");
        }
        AsynchronousJiraSetupFactory.getInstance().setupJIRA(this.getSetupSessionId(), InstantSetupStrategy.SetupParameters.builder().setJiraLicenseKey(this.sharedVariables.getJiraLicenseKey()).setBaseUrl(JiraUrl.constructBaseUrl((HttpServletRequest)this.getHttpRequest())).setServerId(this.getServerId()).setCredentials(this.sharedVariables.getUserCredentials()).setLocale(this.sharedVariables.getLocale()).build());
        JSONObject json = new JSONObject();
        json.put("result", (Object)"OK");
        this.writeJSONToHttpResponse(json);
        return "none";
    }

    @SupportedMethods(value={RequestMethod.POST, RequestMethod.GET})
    public String doSetupFinished() throws IOException, JSONException {
        JSONObject json = new JSONObject();
        if (!this.setupAlready() || !AsynchronousJiraSetupFactory.getInstance().isSetupFinished(this.getSetupSessionId())) {
            throw new RuntimeException("Setup is not yet finished");
        }
        json.put("redirectUrl", (Object)this.getRedirectUrl());
        json.put("SEN", (Object)this.getSupportEntitlementNumber());
        this.writeJSONToHttpResponse(json);
        return "none";
    }

    private String getSupportEntitlementNumber() {
        SortedSet sortedSens = ((JiraLicenseManager)ComponentAccessor.getComponent(JiraLicenseManager.class)).getSupportEntitlementNumbers();
        return sortedSens != null && sortedSens.size() > 0 ? (String)sortedSens.first() : "";
    }

    private String getRedirectUrl() {
        ApplicationUser user = SneakyAutoLoginUtil.logUserInByName(this.sharedVariables.getUserCredentials().get("username"), this.getHttpRequest());
        return this.getApplicationProperties().getString("jira.baseurl") + this.getRedirectPathAfterSetup(user);
    }

    private void writeJSONToHttpResponse(JSONObject json) throws IOException {
        HttpServletResponse response = this.getHttpResponse();
        response.setContentType("application/json");
        String result = json.toString();
        response.getWriter().write(result);
        response.getWriter().flush();
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJiraLicense(String jiraLicense) {
        this.jiraLicense = jiraLicense;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

