/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.DoesNotRequireXsrfCheck;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.LicenseValidationResults;
import com.atlassian.jira.web.action.setup.MyAtlassianComRedirect;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

@UnrestrictedAccess
public class SetupLicense
extends AbstractSetupAction {
    private static final String JIRA_SETUP_LICENSE = "JIRA_SETUP_LICENSE";
    private static final String LICENSE_VALIDATION_RESULTS = "json";
    private final JiraLicenseUpdaterService licenseService;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final MyAtlassianComRedirect myAtlassianComRedirect;
    private String licenseString;
    private JiraLicenseService.ValidationResult validationResult;
    private String licenseValidationJson;
    private String licenseToValidate;

    public SetupLicense(FileFactory fileFactory, JiraLicenseUpdaterService licenseService, JiraSystemRestarter jiraSystemRestarter, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation, MyAtlassianComRedirect myAtlassianComRedirect) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.licenseService = licenseService;
        this.jiraSystemRestarter = jiraSystemRestarter;
        this.myAtlassianComRedirect = myAtlassianComRedirect;
    }

    @DoesNotRequireXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        return this.processLicenseFromEnvironmentVariable();
    }

    private String processLicenseFromEnvironmentVariable() {
        String license = System.getenv(JIRA_SETUP_LICENSE);
        if (StringUtils.isBlank((CharSequence)license)) {
            return "input";
        }
        this.setSetupLicenseKey(license);
        this.doValidation();
        boolean licensePreviouslySet = this.licenseService.isLicenseSet();
        try {
            this.licenseService.setLicense(this.validationResult);
        }
        catch (IllegalStateException ex) {
            this.setSetupLicenseKey(null);
            this.log.warn((Object)"License from environment variable was invalid, falling back to license setup screen...");
            return "input";
        }
        if (!licensePreviouslySet) {
            this.jiraSystemRestarter.ariseSirJIRA();
        }
        return this.getRedirect("SetupAdminAccount!default.jspa");
    }

    @SupportedMethods(value={RequestMethod.POST, RequestMethod.GET})
    public String doValidateLicense() {
        JiraLicenseService.ValidationResult validationResults = this.licenseService.validateApplicationLicense((I18nHelper)this, this.licenseToValidate);
        this.licenseValidationJson = new LicenseValidationResults(validationResults).toJson();
        if (validationResults.getErrorCollection().hasAnyErrors()) {
            ActionContext.getContext();
            ActionContext.getResponse().setStatus(403);
        }
        return LICENSE_VALIDATION_RESULTS;
    }

    public void doValidation() {
        this.validationResult = this.licenseService.validateApplicationLicense((I18nHelper)this, this.licenseString);
        ErrorCollection errorCollection = this.validationResult.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST, RequestMethod.GET})
    protected String doExecute() {
        if (this.setupAlready()) {
            return "setupalready";
        }
        boolean licensePreviouslySet = this.licenseService.isLicenseSet();
        this.licenseService.setLicense(this.validationResult);
        if (!licensePreviouslySet) {
            this.jiraSystemRestarter.ariseSirJIRA();
        }
        return this.getRedirect("SetupAdminAccount!default.jspa");
    }

    public String getMacRedirect() {
        return this.myAtlassianComRedirect.newRedirectWithCallbackTo("/secure/SetupLicense!default.jspa").buildWithPostReturnParameter("setupLicenseKey");
    }

    public void setLicenseToValidate(String license) {
        this.licenseToValidate = license.replace(' ', '+');
    }

    public String getLicenseToValidate() {
        return this.licenseToValidate;
    }

    public String getLicenseValidationResults() {
        return this.licenseValidationJson;
    }

    public void setSetupLicenseKey(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getLicenseString() {
        return this.licenseString;
    }
}

