/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.builder.EmailBuilder;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class ContactAdministrators
extends JiraWebActionSupport {
    private static final String EMAIL_TEMPLATES = "templates/email";
    private static final String EMAIL_TEMPLATE = "contactadministrator.vm";
    private static final Integer PADSIZE = 20;
    private static final String FORM_DISABLED_STATE = "modebreach";
    private final UserPropertyManager userPropertyManager;
    private final RendererManager rendererManager;
    private final MailQueue mailQueue;
    private final UserUtil userUtil;
    private final JiraContactHelper jiraContactHelper;
    private String to;
    private String replyTo;
    private String subject;
    private String details;

    public ContactAdministrators(RendererManager rendererManager, MailQueue mailQueue, UserUtil userUtil, UserPropertyManager userPropertyManager, JiraContactHelper jiraContactHelper) {
        this.rendererManager = rendererManager;
        this.mailQueue = mailQueue;
        this.userUtil = userUtil;
        this.userPropertyManager = userPropertyManager;
        this.jiraContactHelper = jiraContactHelper;
        this.to = this.getText("admin.global.permissions.administer");
        if (this.getLoggedInUser() != null) {
            this.replyTo = this.getLoggedInUser().getEmailAddress();
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.getShouldDisplayForm()) {
            return FORM_DISABLED_STATE;
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (StringUtils.isEmpty((CharSequence)this.replyTo) || !TextUtils.verifyEmail((String)this.replyTo)) {
            this.addError("from", this.getText("admin.errors.must.specify.valid.from.address"));
        }
        if (StringUtils.isEmpty((CharSequence)this.subject)) {
            this.addError("subject", this.getText("admin.errors.must.specify.subject"));
        }
        if (StringUtils.isEmpty((CharSequence)this.details)) {
            this.addError("details", this.getText("admin.errors.must.specify.request.details"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (!this.getShouldDisplayForm()) {
            return FORM_DISABLED_STATE;
        }
        this.send();
        return this.getRedirect("/secure/MyJiraHome.jspa");
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.replyTo;
    }

    public void setFrom(String from) {
        this.replyTo = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean getShouldDisplayForm() {
        return this.jiraContactHelper.isAdministratorContactFormEnabled();
    }

    @ActionViewData(key="renderedMessageContent")
    public String getRenderedMessage() {
        String message = this.getApplicationProperties().getDefaultBackedText("jira.contact.administrators.message");
        if (StringUtils.isEmpty((CharSequence)message) || !this.getShouldDisplayForm()) {
            message = this.getText("admin.generalconfiguration.contact.administrators.message.default");
        }
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    @ActionViewData
    public boolean hasCustomMessage() {
        String message = this.getApplicationProperties().getDefaultBackedText("jira.contact.administrators.message");
        return !StringUtils.isEmpty((CharSequence)message);
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getDataMap() {
        HashMap data = Maps.newHashMap();
        data.put("to", this.getTo());
        data.put("from", this.getFrom());
        data.put("subject", this.getSubject());
        data.put("details", this.getDetails());
        data.put("errors", this.getErrors());
        data.put("atlToken", this.getXsrfToken());
        return data;
    }

    public void send() throws MailException {
        Collection administrators = this.userUtil.getJiraAdministrators();
        for (ApplicationUser administrator : administrators) {
            if (!administrator.isActive()) continue;
            this.sendTo(administrator);
        }
    }

    private void sendTo(ApplicationUser administrator) throws MailException {
        try {
            HashMap velocityParams = Maps.newHashMap();
            velocityParams.put("from", this.replyTo);
            velocityParams.put("content", this.details);
            velocityParams.put("padSize", PADSIZE);
            velocityParams.put("subject", this.subject);
            Email email = new Email(administrator.getEmailAddress());
            email.setReplyTo(this.replyTo);
            MailQueueItem item = new EmailBuilder(email, this.getMimeType(administrator), I18nBean.getLocaleFromUser(administrator)).withSubject("$subject").withBodyFromFile(this.getTemplateDirectory(administrator) + EMAIL_TEMPLATE).addParameters(velocityParams).renderLater();
            this.mailQueue.addItem(item);
        }
        catch (Exception e) {
            this.log.error((Object)"Error sending JIRA Administrator email", (Throwable)e);
        }
    }

    private String getTemplateDirectory(ApplicationUser to) {
        return "templates/email/" + this.getFormat(to) + "/";
    }

    private String getMimeType(ApplicationUser to) {
        if (this.getFormat(to).equals("html")) {
            return "text/html";
        }
        return "text/plain";
    }

    public String getFormat(ApplicationUser user) {
        String prefFormat = this.userPropertyManager.getPropertySet(user).getString("user.notifications.mimetype");
        if (StringUtils.isNotBlank((CharSequence)prefFormat) && (prefFormat.equals("html") || prefFormat.equals("text"))) {
            return prefFormat;
        }
        return "html";
    }

    private static class MimeTypes {
        static final String TEXT_HTML = "text/html";
        static final String TEXT_PLAIN = "text/plain";

        private MimeTypes() {
        }
    }
}

