/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventDispatcher;
import com.atlassian.jira.event.user.UserEventFactory;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.mobile.JiraMobileUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;

@UnrestrictedAccess
public class ForgotLoginDetails
extends JiraWebActionSupport {
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_EMAIL = "email";
    @VisibleForTesting
    static final String PARAM_PASSWORD_TOKEN = "password.token";
    @VisibleForTesting
    static final String PARAM_PASSWORD_HOURS = "password.hours";
    @VisibleForTesting
    static final String PARAM_USERS = "users";
    @VisibleForTesting
    static final String PARAM_MANAGED_USERS = "managedUsers";
    @VisibleForTesting
    static final String PARAM_UNMANAGED_USERS = "unmanagedUsers";
    @VisibleForTesting
    static final String PASSWORD_SUCCESS_VIEW = "password_success";
    @VisibleForTesting
    static final String USERNAME_SUCCESS_VIEW = "username_success";
    private final UserUtil userUtil;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final UserSearchService userSearchService;
    private final PageBuilderService pageBuilderService;
    private final transient UserEventFactory userEventFactory;
    private String username;
    private String email;
    private boolean forgotPassword = false;
    private boolean forgotUserName = false;
    @VisibleForTesting
    static final String FORGOT_PASSWORD = "forgotPassword";
    @VisibleForTesting
    static final String FORGOT_USER_NAME = "forgotUserName";
    private static final String JIRA_LOGIN_URI = "/login.jsp";
    private static final String JIRA_HOME_URI = "/secure/MyJiraHome.jspa";

    public ForgotLoginDetails(UserUtil userUtil, ApplicationProperties applicationProperties, UserManager userManager, UserSearchService userSearchService, PageBuilderService pageBuilderService, UserEventFactory userEventFactory) {
        this.userUtil = userUtil;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.userSearchService = userSearchService;
        this.pageBuilderService = pageBuilderService;
        this.userEventFactory = userEventFactory;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() {
        if (this.isExternalUserManagement() || !this.userManager.hasPasswordWritableDirectory()) {
            throw new IllegalStateException("User login details can not be reset for this JIRA site.");
        }
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:forgot-login-details-validation");
        this.forgotPassword = true;
        return "input";
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doSend() {
        if (this.isExternalUserManagement() || !this.userManager.hasPasswordWritableDirectory()) {
            throw new IllegalStateException("User login details can not be reset for this JIRA site.");
        }
        if (this.forgotPassword) {
            return this.doPassword();
        }
        return this.doUserNames();
    }

    private String doPassword() {
        UserEvent event;
        ApplicationUser user = this.userManager.getUserByName(this.username);
        if (!this.isSubmittedUserNameValid()) {
            Map params = MapBuilder.build((Object)PARAM_USERNAME, (Object)this.username);
            event = this.userEventFactory.newForgotPasswordEvent(params, user);
        } else if (this.userManager.canUpdateUserPassword(user)) {
            UserUtil.PasswordResetToken passwordResetToken = this.userUtil.generatePasswordResetToken(user);
            Map params = MapBuilder.build((Object)PARAM_USERNAME, (Object)this.username, (Object)PARAM_PASSWORD_TOKEN, (Object)passwordResetToken.getToken(), (Object)PARAM_PASSWORD_HOURS, (Object)passwordResetToken.getExpiryHours());
            event = this.userEventFactory.newForgotPasswordEvent(params, user);
        } else {
            Map params = MapBuilder.build((Object)PARAM_USERNAME, (Object)this.username);
            event = this.userEventFactory.newCannotChangePasswordEvent(params, user);
        }
        UserEventDispatcher.dispatch(event);
        return this.passwordSuccessPage();
    }

    private String passwordSuccessPage() {
        return PASSWORD_SUCCESS_VIEW;
    }

    private boolean isSubmittedUserNameValid() {
        return this.username != null && this.userManager.getUserByName(this.username) != null;
    }

    private String doUserNames() {
        UserEvent event = this.isSubmittedEmailValid() ? this.getEventOfExistingEmail() : this.getEventOfUnknownEmail();
        UserEventDispatcher.dispatch(event);
        return this.userNameSuccessPage();
    }

    private UserEvent getEventOfExistingEmail() {
        ArrayList users = Lists.newArrayList((Iterable)this.userSearchService.findUsersByEmail(this.email));
        ArrayList managedUsers = Lists.newArrayListWithCapacity((int)users.size());
        ArrayList unManagedUsers = Lists.newArrayListWithCapacity((int)users.size());
        for (ApplicationUser user : users) {
            if (this.userManager.canUpdateUserPassword(user)) {
                managedUsers.add(user);
                continue;
            }
            unManagedUsers.add(user);
        }
        Map eventParams = MapBuilder.build((Object)PARAM_USERS, (Object)users, (Object)PARAM_MANAGED_USERS, (Object)managedUsers, (Object)PARAM_UNMANAGED_USERS, (Object)unManagedUsers);
        return this.userEventFactory.newForgotUsernameEvent(eventParams, (ApplicationUser)users.get(0));
    }

    private UserEvent getEventOfUnknownEmail() {
        Map params = MapBuilder.build((Object)PARAM_EMAIL, (Object)this.email);
        return this.userEventFactory.newForgotUsernameEvent(params, null);
    }

    private String userNameSuccessPage() {
        return USERNAME_SUCCESS_VIEW;
    }

    private boolean isSubmittedEmailValid() {
        return this.userSearchService.findUsersByEmail(this.email).iterator().hasNext();
    }

    private boolean isExternalUserManagement() {
        return this.applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    public boolean checked(String id) {
        if (FORGOT_PASSWORD.equals(id)) {
            return this.forgotPassword;
        }
        if (FORGOT_USER_NAME.equals(id)) {
            return this.forgotUserName;
        }
        return false;
    }

    public String displayStyle(String id) {
        if (FORGOT_PASSWORD.equals(id)) {
            return this.forgotPassword ? "" : "display:none";
        }
        if (FORGOT_USER_NAME.equals(id)) {
            return this.forgotUserName ? "" : "display:none";
        }
        return "";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setForgotten(String forgotten) {
        this.forgotPassword = FORGOT_PASSWORD.equals(forgotten);
        this.forgotUserName = FORGOT_USER_NAME.equals(forgotten);
    }

    public String getCancelLinkURI() {
        return JiraMobileUtils.isMobileAppRequest(this.getHttpRequest()) ? JIRA_LOGIN_URI : JIRA_HOME_URI;
    }
}

