/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.event.user.UserPreferencesUpdatedEvent;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.RegionInfoImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneInfoImpl;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

@OpenAPIDefinition
@Path(value="secure")
@Produces(value={"text/html"})
@Tag(name="webwork")
@LicensedOnly
public class UpdateUserPreferences
extends JiraWebActionSupport {
    public static final int MAX_ISSUES_PER_PAGE_SETTING = 1000;
    private final UserPreferencesManager userPreferencesManager;
    private final LocaleManager localeManager;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    private final TimeZoneService timeZoneManager;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final DCFeatureLicenseChecker dcFeatureLicenseChecker;
    private String username;
    private long userIssuesPerPage;
    private String userNotificationsMimeType;
    private String userLocale;
    private boolean notifyOwnChanges;
    private boolean shareDefault;
    private boolean keyboardShortcutsEnabled;
    private String timeZoneId;
    private String autoWatchPreference;
    private boolean externalLinksNewWindow;
    private String quickSearchingMode;

    public UpdateUserPreferences(UserPreferencesManager userPreferencesManager, LocaleManager localeManager, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory, TimeZoneService timeZoneManager, EventPublisher eventPublisher, FeatureManager featureManager, DCFeatureLicenseChecker dcFeatureLicenseChecker) {
        this.userPreferencesManager = userPreferencesManager;
        this.localeManager = localeManager;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
        this.timeZoneManager = timeZoneManager;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.dcFeatureLicenseChecker = dcFeatureLicenseChecker;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null || !current.getUsername().equals(this.username)) {
            return "error";
        }
        this.setUserIssuesPerPage(this.getUserPreferences().getLong("user.issues.per.page"));
        this.setUserNotificationsMimeType(this.getUserPreferences().getString("user.notifications.mimetype"));
        this.setNotifyOwnChanges(this.getUserPreferences().getBoolean("user.notify.own.changes"));
        this.setShareDefault(this.getUserPreferences().getBoolean("user.default.share.private"));
        this.setUserLocale(this.getUserPreferences().getString("jira.user.locale"));
        this.setKeyboardShortcutsEnabled(!this.getUserPreferences().getBoolean("user.keyboard.shortcuts.disabled"));
        this.setAutoWatchPreference(this.getUserAutoWatchPreference(this.getUserPreferences()).name());
        this.externalLinksNewWindow = this.getUserPreferences().getBoolean("user.external.links.new.window");
        this.setQuickSearchingMode(this.getUserPreferences().getString("user.quicksearching.mode"));
        return "input";
    }

    private AutoWatchPreference getUserAutoWatchPreference(Preferences userPreferences) {
        ExtendedPreferences extendedPreferences;
        boolean autoWatchForUserSet;
        if (userPreferences instanceof ExtendedPreferences && (autoWatchForUserSet = (extendedPreferences = (ExtendedPreferences)userPreferences).containsValue("user.autowatch.disabled"))) {
            boolean autoWatchDisabled = extendedPreferences.getBoolean("user.autowatch.disabled");
            if (autoWatchDisabled) {
                return AutoWatchPreference.DISABLED;
            }
            return AutoWatchPreference.ENABLED;
        }
        return AutoWatchPreference.INHERIT;
    }

    public boolean getShowPluginHints() {
        return this.getApplicationProperties().getOption("show.plugin.marketing.hints");
    }

    public String getTacUrl() {
        return HelpUtil.getInstance().getHelpPath("userpreferences.language.more.from.tac").getUrl();
    }

    public long getUserIssuesPerPage() {
        return this.userIssuesPerPage;
    }

    public void setUserIssuesPerPage(long aLong) {
        this.userIssuesPerPage = aLong;
    }

    public String getUserNotificationsMimeType() {
        return this.userNotificationsMimeType;
    }

    public void setUserNotificationsMimeType(String userNotificationsMimeType) {
        this.userNotificationsMimeType = userNotificationsMimeType;
    }

    public void setShareDefault(boolean isPublic) {
        this.shareDefault = isPublic;
    }

    public boolean isShareDefault() {
        return this.shareDefault;
    }

    public Collection<TextOption> getOwnChangesList() {
        String notify = this.getText("preferences.notification.on.short");
        String doNotNotify = this.getText("preferences.notification.off.short");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("true", notify), new TextOption("false", doNotNotify)});
    }

    public Collection<TextOption> getShareList() {
        String publicText = this.getText("preferences.default.share.shared.short");
        String privateText = this.getText("preferences.default.share.unshared.short");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("false", publicText), new TextOption("true", privateText)});
    }

    public String getShareValue() {
        return String.valueOf(this.getUserPreferences().getBoolean("user.default.share.private"));
    }

    public Collection<TextOption> getKeyboardShortcutList() {
        String enabledText = this.getText("preferences.keyboard.shortcuts.enabled");
        String disabledText = this.getText("preferences.keyboard.shortcuts.disabled");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("true", enabledText), new TextOption("false", disabledText)});
    }

    public String getKeyboardShortcutValue() {
        return String.valueOf(!this.getUserPreferences().getBoolean("user.keyboard.shortcuts.disabled"));
    }

    public Collection<TextOption> getAutowatchList() {
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption(AutoWatchPreference.ENABLED.name(), this.getText("preferences.autowatch.enabled")), new TextOption(AutoWatchPreference.DISABLED.name(), this.getText("preferences.autowatch.disabled")), new TextOption(AutoWatchPreference.INHERIT.name(), this.getText("preferences.autowatch.inherit"))});
    }

    public List<TextOption> getYesNoList() {
        return ImmutableList.of((Object)new TextOption("true", this.getText("preferences.external.links.new.window.enabled")), (Object)new TextOption("false", this.getText("preferences.external.links.new.window.disabled")));
    }

    public List<TextOption> getQuickSearchingModeOptionsList() {
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption(QuickSearchingModePreference.SMARTQUERY.name().toLowerCase(), this.getText("preferences.quicksearch.option.smartquery")), new TextOption(QuickSearchingModePreference.TEXT.name().toLowerCase(), this.getText("preferences.quicksearch.option.text"))});
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(String userLocale) {
        this.userLocale = userLocale;
    }

    public void setDefaultUserTimeZone(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public List<RegionInfo> getTimeZoneRegions() {
        List regions = this.timeZoneManager.getTimeZoneRegions(this.getJiraServiceContext());
        regions.add(0, new RegionInfoImpl("JIRA", this.getText("timezone.region.jira")));
        return regions;
    }

    public List<TimeZoneInfo> getTimeZoneInfos() {
        List timeZoneInfos = this.timeZoneManager.getTimeZoneInfos(this.getJiraServiceContext());
        TimeZoneInfo jiraDefaultTimeZone = this.timeZoneManager.getDefaultTimeZoneInfo(this.getJiraServiceContext());
        TimeZoneInfoImpl timeZoneInfo = new TimeZoneInfoImpl("JIRA", jiraDefaultTimeZone.getDisplayName(), jiraDefaultTimeZone.toTimeZone(), this.getJiraServiceContext().getI18nBean(), "JIRA");
        timeZoneInfos.add(timeZoneInfo);
        return timeZoneInfos;
    }

    public String getConfiguredTimeZoneRegion() {
        if (this.timeZoneManager.usesJiraTimeZone(this.getJiraServiceContext())) {
            return "JIRA";
        }
        return this.timeZoneManager.getUserTimeZoneInfo(this.getJiraServiceContext()).getRegionKey();
    }

    public String getConfiguredTimeZoneId() {
        if (this.timeZoneManager.usesJiraTimeZone(this.getJiraServiceContext())) {
            return "JIRA";
        }
        return this.timeZoneManager.getUserTimeZoneInfo(this.getJiraServiceContext()).getTimeZoneId();
    }

    public Map<String, String> getMimeTypes() {
        return ImmutableMap.of((Object)"html", (Object)"HTML", (Object)"text", (Object)"Text");
    }

    public boolean getNotifyOwnChanges() {
        return this.notifyOwnChanges;
    }

    public void setNotifyOwnChanges(boolean notifyOwnChanges) {
        this.notifyOwnChanges = notifyOwnChanges;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Map<String, String> getInstalledLocales() {
        return this.localeManager.getInstalledLocalesWithDefault(this.getApplicationProperties().getDefaultLocale(), (I18nHelper)this);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    @POST
    @Path(value="UpdateUserPreferences!execute.jspa")
    @Operation(description="Renders a page that allows user to manage user preferences.", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns html page.", responseCode="200")
    public String doExecute() throws Exception {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        Preferences userPreferences = this.getUserPreferences();
        userPreferences.setLong("user.issues.per.page", this.getUserIssuesPerPage());
        userPreferences.setString("user.notifications.mimetype", this.getUserNotificationsMimeType());
        userPreferences.setBoolean("user.default.share.private", this.isShareDefault());
        userPreferences.setBoolean("user.notify.own.changes", this.getNotifyOwnChanges());
        userPreferences.setBoolean("user.keyboard.shortcuts.disabled", !this.isKeyboardShortcutsEnabled());
        userPreferences.setString("user.quicksearching.mode", this.getQuickSearchingMode());
        if (this.getShowAutowatch()) {
            AutoWatchPreference watchPreference = AutoWatchPreference.valueOf(this.autoWatchPreference);
            if (watchPreference.equals((Object)AutoWatchPreference.INHERIT)) {
                if (userPreferences instanceof ExtendedPreferences && ((ExtendedPreferences)userPreferences).containsValue("user.autowatch.disabled")) {
                    userPreferences.remove("user.autowatch.disabled");
                }
            } else {
                userPreferences.setBoolean("user.autowatch.disabled", watchPreference == AutoWatchPreference.DISABLED);
            }
        }
        if ("-1".equals(this.getUserLocale())) {
            String locale = this.getUserPreferences().getString("jira.user.locale");
            if (locale != null) {
                this.getUserPreferences().remove("jira.user.locale");
            }
        } else {
            this.getUserPreferences().setString("jira.user.locale", this.getUserLocale());
        }
        if ("JIRA".equals(this.timeZoneId)) {
            this.timeZoneManager.clearUserDefaultTimeZone(this.getJiraServiceContext());
        } else {
            this.timeZoneManager.setUserDefaultTimeZone(this.timeZoneId, this.getJiraServiceContext());
        }
        userPreferences.setBoolean("user.external.links.new.window", this.externalLinksNewWindow);
        this.eventPublisher.publish((Object)new UserPreferencesUpdatedEvent(current, Long.valueOf(this.getUserIssuesPerPage()), this.getUserNotificationsMimeType(), this.getUserLocale(), this.timeZoneManager.getUserTimeZoneInfo(this.getJiraServiceContext()).getDisplayName(), this.getNotifyOwnChanges(), this.shareDefault, this.isKeyboardShortcutsEnabled(), this.autoWatchPreference, this.externalLinksNewWindow, this.getQuickSearchingMode()));
        Map session = ActionContext.getSession();
        session.remove("jira.issue.generic.pager");
        this.getSessionPagerFilterManager().setCurrentObject(null);
        return this.returnComplete("ViewProfile.jspa");
    }

    private SessionPagerFilterManager getSessionPagerFilterManager() {
        return this.sessionSearchObjectManagerFactory.createPagerFilterManager();
    }

    protected void doValidation() {
        this.localeManager.validateUserLocale(this.getLoggedInUser(), this.getUserLocale(), (ErrorCollection)this);
        if (!StringUtils.equals((CharSequence)this.getUserNotificationsMimeType(), (CharSequence)"text") && !StringUtils.equals((CharSequence)this.getUserNotificationsMimeType(), (CharSequence)"html")) {
            this.addError("userNotificationsMimeType", this.getText("preferences.invalid.mime.type"));
        }
        if (this.getUserIssuesPerPage() <= 0L || this.getUserIssuesPerPage() > 1000L) {
            this.addError("userIssuesPerPage", this.getText("preferences.issues.per.page.error"));
        }
        super.doValidation();
    }

    public boolean isKeyboardShortcutsEnabled() {
        return this.keyboardShortcutsEnabled;
    }

    public void setKeyboardShortcutsEnabled(boolean keyboardShortcutsEnabled) {
        this.keyboardShortcutsEnabled = keyboardShortcutsEnabled;
    }

    public String getAutoWatchPreference() {
        return this.autoWatchPreference;
    }

    public void setAutoWatchPreference(String autoWatchPreference) {
        this.autoWatchPreference = autoWatchPreference;
    }

    public String getExternalLinksNewWindow() {
        return Boolean.toString(this.externalLinksNewWindow);
    }

    public void setExternalLinksNewWindow(String externalLinksNewWindow) {
        this.externalLinksNewWindow = Boolean.valueOf(externalLinksNewWindow);
    }

    public boolean getShowAutowatch() {
        return this.getApplicationProperties().getOption("jira.option.watching");
    }

    public boolean isShowExternalLinksInNewWindow() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.EXTERNAL_LINKS_NEW_IN_WINDOW);
    }

    public boolean isShowQuickSearchingModeSettable() {
        return this.dcFeatureLicenseChecker.isEnabled(JiraFeatureFlagRegistrar.QUICK_SEARCHING_MODE_SETTABLE);
    }

    public String getQuickSearchingMode() {
        return this.quickSearchingMode;
    }

    public void setQuickSearchingMode(String quickSearchingMode) {
        this.quickSearchingMode = quickSearchingMode;
    }

    private static enum AutoWatchPreference {
        ENABLED,
        DISABLED,
        INHERIT;

    }

    public static enum QuickSearchingModePreference {
        SMARTQUERY,
        TEXT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

