/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.ClauseTooComplexSearchException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.web.action.util.AbstractSharedEntityDisplayBean;
import com.atlassian.jira.web.action.util.sharing.SharesListHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SearchRequestDisplayBean
extends AbstractSharedEntityDisplayBean
implements SharesListHelper {
    private final SearchRequest request;
    private final SearchService searchService;
    private final FilterSubscriptionService subscriptionService;
    private Collection<FilterSubscription> subscriptions;
    private long issueCount = -1L;

    public SearchRequestDisplayBean(JiraAuthenticationContext authCtx, SearchRequest request, SearchService searchService, FavouritesService favouriteService, GlobalPermissionManager permissionManager, FilterSubscriptionService subscriptionService, ShareTypeFactory shareTypeFactory, UserFormats userFormats, ShareManager shareManager) {
        super(authCtx, (SharedEntity)request, favouriteService, permissionManager, shareTypeFactory, userFormats, shareManager, "search_request");
        this.request = request;
        this.searchService = searchService;
        this.subscriptionService = subscriptionService;
    }

    public long getIssueCount() {
        if (this.issueCount == -1L) {
            try {
                this.issueCount = this.searchService.searchCount(this.authCtx.getUser(), this.request != null ? this.request.getQuery() : null);
            }
            catch (ClauseTooComplexSearchException e) {
                return -1L;
            }
            catch (SearchException e) {
                throw new RuntimeException(e);
            }
        }
        return this.issueCount;
    }

    public long getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    private Collection<FilterSubscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = this.subscriptionService.getVisibleFilterSubscriptions(this.authCtx.getUser(), this.request);
        }
        return this.subscriptions;
    }

    public static class Factory {
        private final JiraAuthenticationContext authCtx;
        private final SearchService searchService;
        private final FavouritesService favouriteService;
        private final GlobalPermissionManager permissionManager;
        private final FilterSubscriptionService subscriptionService;
        private final ShareTypeFactory shareTypeFactory;
        private final UserFormats userFormats;
        private final ShareManager shareManager;

        public Factory(JiraAuthenticationContext authCtx, SearchService searchService, FavouritesService favouriteService, GlobalPermissionManager permissionManager, FilterSubscriptionService subscriptionService, ShareTypeFactory shareTypeFactory, UserFormats userFormats, ShareManager shareManager) {
            this.authCtx = authCtx;
            this.searchService = searchService;
            this.favouriteService = favouriteService;
            this.permissionManager = permissionManager;
            this.subscriptionService = subscriptionService;
            this.shareTypeFactory = shareTypeFactory;
            this.userFormats = userFormats;
            this.shareManager = shareManager;
        }

        public SearchRequestDisplayBean createDisplayBean(SearchRequest request) {
            return new SearchRequestDisplayBean(this.authCtx, request, this.searchService, this.favouriteService, this.permissionManager, this.subscriptionService, this.shareTypeFactory, this.userFormats, this.shareManager);
        }

        public List<SearchRequestDisplayBean> createDisplayBeans(Collection<SearchRequest> requests) {
            if (requests == null || requests.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<SearchRequestDisplayBean> displayList = new ArrayList<SearchRequestDisplayBean>(requests.size());
            for (SearchRequest searchRequest : requests) {
                displayList.add(this.createDisplayBean(searchRequest));
            }
            return displayList;
        }
    }
}

