/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.Named;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

@AnonymousSiteAccess
public class ShowConstantsHelp
extends JiraWebActionSupport {
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final PermissionManager permissionManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final StatusCategoryManager statusCategoryManager;

    public ShowConstantsHelp(ConstantsManager constantsManager, SubTaskManager subTaskManager, PermissionManager permissionManager, IssueSecurityLevelManager issueSecurityLevelManager, StatusCategoryManager statusCategoryManager) {
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.permissionManager = permissionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.statusCategoryManager = statusCategoryManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        if (!this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, this.getLoggedInUser())) {
            return "error";
        }
        return super.doExecute();
    }

    public boolean isSubTasksEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public Collection<IssueType> getIssueTypes() {
        return this.constantsManager.getRegularIssueTypeObjects();
    }

    public IssueType getIssueType(String id) {
        return this.constantsManager.getIssueType(id);
    }

    public Collection<IssueType> getSubTaskIssueTypes() {
        if (!this.isSubTasksEnabled()) {
            throw new IllegalStateException("Should not call this method as subtasks are disabled");
        }
        return this.constantsManager.getSubTaskIssueTypeObjects();
    }

    public Collection getPriorities() {
        return this.constantsManager.getPriorities();
    }

    public Collection getStatuses() {
        return this.constantsManager.getStatuses();
    }

    public boolean isStatusCategoriesEnabled() {
        return this.statusCategoryManager.isStatusAsLozengeEnabled();
    }

    public Collection<SimpleStatus> getStatusCategories() {
        if (!this.isStatusCategoriesEnabled()) {
            throw new IllegalStateException("Should not call this method as subtasks are disabled");
        }
        TreeSet categories = Sets.newTreeSet((Comparator)Named.NAME_COMPARATOR);
        for (StatusCategory category : this.statusCategoryManager.getStatusCategories()) {
            categories.add(new SimpleStatusImpl(null, this.getNameTranslation(category), this.getDescTranslation(category), category, null));
        }
        return categories;
    }

    public Collection getResolutions() {
        return this.constantsManager.getResolutions();
    }

    public Collection<IssueSecurityLevel> getSecurityLevels() {
        return this.issueSecurityLevelManager.getUsersSecurityLevels(this.getSelectedProjectObject(), this.getLoggedInUser());
    }

    private String getNameTranslation(StatusCategory category) {
        return this.getText("common.statuscategory." + category.getKey());
    }

    private String getDescTranslation(StatusCategory category) {
        return this.getText("common.statuscategory." + category.getKey() + ".description");
    }
}

