/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.core.util.DataUtils;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.filestore.S3FileStoreConfig;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.imports.xml.BackupPathProvider;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.jira.web.action.util.DataCleaner;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
@SystemAdminOnly
public class XmlBackup
extends ProjectActionSupport {
    private static final String CONFIRM = "confirm";
    private static final String FIX_INVALID_XML_CHARACTERS = "fixchars";
    private static final int MAX_FILENAME_LENGTH = 500;
    private static final String INVALID_CHARACTERS = "(0x00?0x1f and 0x80?0x9f), /, ?, <, >, :, *, |, \\, or \"";
    private String filename;
    private String destinationFile;
    boolean confirm = false;
    private final DevModeSecretSauce devModeSecretSauce;
    private final ExportService exportService;
    private final transient BackupPathProvider backupPathProvider;

    public XmlBackup(ExportService exportService, JiraProperties jiraSystemProperties, BackupPathProvider backupPathProvider) {
        this.exportService = exportService;
        this.devModeSecretSauce = new DevModeSecretSauce(jiraSystemProperties);
        this.backupPathProvider = backupPathProvider;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (StringUtils.isBlank((CharSequence)this.filename)) {
            this.addError("filename", this.getText("admin.errors.export.must.enter.file.location"));
        } else {
            File safeBackupPath = this.getSafeBackupPath();
            try {
                new File(safeBackupPath, this.filename).getCanonicalFile();
            }
            catch (IOException e) {
                this.addError("filename", this.getText("admin.errors.export.file.invalid", this.filename));
            }
            this.filename = this.filename.trim();
            if (this.filename.endsWith(".")) {
                this.addError("filename", this.getText("admin.errors.export.file.invalid.endingdot", this.filename));
            } else if (this.filename.length() > 500) {
                this.addError("filename", this.getText("admin.errors.export.file.invalid.toolong", 500));
            } else if (this.containsInvalidCharacters(this.filename)) {
                this.addError("filename", this.getText("admin.errors.export.file.invalid.characters", INVALID_CHARACTERS));
            }
        }
    }

    private boolean containsInvalidCharacters(String fileNamePrefix) {
        int i;
        StringBuilder forbiddenCharacters = new StringBuilder("/?<>:*|\"\\");
        for (i = 0; i <= 31; ++i) {
            forbiddenCharacters.appendCodePoint(i);
        }
        for (i = 128; i <= 159; ++i) {
            forbiddenCharacters.appendCodePoint(i);
        }
        return fileNamePrefix != null && StringUtils.containsAny((CharSequence)fileNamePrefix, (CharSequence)forbiddenCharacters.toString());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        try {
            Optional<String> optionalResult = this.updateFileNameAndDestinationFile();
            if (optionalResult.isPresent()) {
                return optionalResult.get();
            }
            this.log.warn((Object)String.format("The filename that will be used for exporting is: '%s'", this.filename));
            ServiceOutcome<Void> outcome = this.devModeSecretSauce.isBoneFideJiraDeveloper() ? this.exportService.exportForDevelopment(this.getLoggedInUser(), this.filename, TaskProgressSink.NULL_SINK) : this.exportService.export(this.getLoggedInUser(), this.filename, TaskProgressSink.NULL_SINK);
            if (outcome.isValid()) {
                return "success";
            }
            this.addErrors(outcome.getErrorCollection().getErrors());
            this.addErrorMessages(outcome.getErrorCollection().getErrorMessages());
            if (outcome.getErrorCollection().getReasons().contains(ErrorCollection.Reason.VALIDATION_FAILED)) {
                return FIX_INVALID_XML_CHARACTERS;
            }
            return "error";
        }
        catch (Exception e) {
            this.log.error((Object)("Exception occurred backing up: " + e), (Throwable)e);
            this.addErrorMessage(TextUtils.plainTextToHtml((String)this.getText("admin.errors.export.exception.occured.backing.up", e)));
            return "error";
        }
    }

    private Optional<String> updateFileNameAndDestinationFile() {
        if (StringUtils.isEmpty((CharSequence)this.filename)) {
            return Optional.empty();
        }
        this.filename = this.addFileExtension(this.filename);
        if (this.isS3InUse()) {
            this.destinationFile = this.filename = this.addDatePrefixToFilename(this.filename);
            return Optional.empty();
        }
        File potentialSafeFile = this.getPotentialSafeFile();
        this.destinationFile = potentialSafeFile.getAbsoluteFile().toString();
        Optional<String> errorOrRedirect = this.validatePotentialSafeFile(potentialSafeFile);
        if (errorOrRedirect.isPresent()) {
            return errorOrRedirect;
        }
        this.filename = this.destinationFile;
        return Optional.empty();
    }

    private Optional<String> validatePotentialSafeFile(File potentialSafeFile) {
        if (!potentialSafeFile.exists()) {
            return Optional.empty();
        }
        if (!potentialSafeFile.canWrite()) {
            this.addError("filename", this.getText("admin.errors.export.file.exists.unwriteable", "'" + this.destinationFile + "'"));
            return Optional.of(this.getResult());
        }
        if (!this.confirm) {
            return Optional.of(CONFIRM);
        }
        return Optional.empty();
    }

    private File getPotentialSafeFile() {
        File safeBackupPath = this.getSafeBackupPath();
        File potentialFile = new File(this.filename);
        File potentialSafeFile = new File(safeBackupPath, potentialFile.getName());
        if (this.devModeSecretSauce.isBoneFideJiraDeveloper() && potentialFile.isAbsolute()) {
            potentialSafeFile = potentialFile;
        }
        return potentialSafeFile;
    }

    private String addFileExtension(String filenameToAddExtension) {
        if (this.devModeSecretSauce.isBoneFideJiraDeveloper()) {
            return DataUtils.getXmlFilename((String)filenameToAddExtension.trim());
        }
        return DataUtils.getZipFilename((String)filenameToAddExtension.trim());
    }

    private String addDatePrefixToFilename(String filenameToAddPrefix) {
        ZonedDateTime now = ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC"));
        return DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(now) + "_" + filenameToAddPrefix;
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doFixChars() throws Exception {
        OfBizDelegator ofBizDelegator = (OfBizDelegator)ComponentAccessor.getComponent(OfBizDelegator.class);
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        DataCleaner dataCleaner = new DataCleaner(applicationProperties, ofBizDelegator);
        dataCleaner.clean();
        return "input";
    }

    public File getSafeBackupPath() {
        return XmlBackup.fileStores().getExportBackupsPath().asJavaFile().getAbsoluteFile();
    }

    private static FileStores fileStores() {
        return (FileStores)ComponentAccessor.getComponentOfType(FileStores.class);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (TextUtils.stringSet((String)filename)) {
            this.filename = filename;
        }
    }

    public Optional<S3FileStoreConfig> getS3FileStoreConfig() {
        return this.backupPathProvider.getS3FileStoreConfig();
    }

    public boolean isS3InUse() {
        return this.backupPathProvider.isS3InUse();
    }

    public String getDestinationFile() {
        return this.destinationFile;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

