/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util.sharing;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.search.GroupShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.search.UserShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.UserShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.bean.ShareTypeRendererBean;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class SharedEntitySearchViewHelper<E extends SharedEntity> {
    private static final String ERRORKEY_SHARES = "shares";
    private final SharedEntity.TypeDescriptor entityType;
    private final GlobalPermissionManager permissionManager;
    private static final Map<String, SharedEntityColumn> SORT_COLUMN_TO_SHARED_ENTITY_COLUMN_MAP = ImmutableMap.of((Object)"description", (Object)SharedEntityColumn.DESCRIPTION, (Object)"favcount", (Object)SharedEntityColumn.FAVOURITE_COUNT, (Object)"name", (Object)SharedEntityColumn.NAME, (Object)"owner", (Object)SharedEntityColumn.OWNER);
    private static final int PAGE_WIDTH_FAVOURITE = 20;
    private static final int PAGE_WIDTH_DEFAULT = 20;
    private final ShareTypeFactory shareTypeFactory;
    private final JiraAuthenticationContext authCtx;
    private final String applicationContext;
    private final String actionUrlPrefix;
    private final String viewParameter;
    private final String viewValue;
    private String searchName = null;
    private String searchOwnerUserName = null;
    private String searchShareType = null;
    private String groupShare = null;
    private String userShare = null;
    private Long pagingOffset = null;
    private Long projectShare = null;
    private Long roleShare = null;
    private final FeatureManager featureManager;
    private final UserManager userManager;
    private String sortColumn = "name";
    private boolean sortAscending = true;
    private List<ShareTypeRendererBean> shareTypes;

    public SharedEntitySearchViewHelper(ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authCtx, String applicationContext, String actionUrlPrefix, String viewParameter, String viewValue, SharedEntity.TypeDescriptor entityType, FeatureManager featureManager, UserManager userManager, GlobalPermissionManager permissionManager) {
        Assertions.notNull((String)"shareTypeFactory", (Object)shareTypeFactory);
        Assertions.notNull((String)"authCtx", (Object)authCtx);
        Assertions.notBlank((String)"actionUrlPrefix", (String)actionUrlPrefix);
        Assertions.notBlank((String)"viewParameter", (String)viewParameter);
        Assertions.notBlank((String)"viewValue", (String)viewValue);
        Assertions.notNull((String)"entityType", (Object)entityType);
        Assertions.notNull((String)"featureManager", (Object)featureManager);
        Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.entityType = entityType;
        this.shareTypeFactory = shareTypeFactory;
        this.authCtx = authCtx;
        this.actionUrlPrefix = actionUrlPrefix;
        this.viewParameter = viewParameter;
        this.viewValue = viewValue;
        this.applicationContext = applicationContext;
        this.featureManager = featureManager;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getSearchOwnerUserName() {
        return this.searchOwnerUserName;
    }

    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.searchOwnerUserName = searchOwnerUserName;
    }

    public String getSearchShareType() {
        return this.searchShareType;
    }

    public void setSearchShareType(String searchShareType) {
        this.searchShareType = searchShareType;
    }

    public void setGroupShare(String groupShare) {
        this.groupShare = groupShare;
    }

    public String getGroupShare() {
        return this.groupShare;
    }

    public String getUserShare() {
        return this.userShare;
    }

    public void setUserShare(String userShare) {
        this.userShare = userShare;
    }

    public Long getPagingOffset() {
        return this.pagingOffset;
    }

    public void setProjectShare(String projectShare) {
        try {
            this.projectShare = Long.valueOf(projectShare);
        }
        catch (NumberFormatException e) {
            this.projectShare = null;
        }
    }

    public String getProjectShare() {
        return this.projectShare == null ? null : this.projectShare.toString();
    }

    public void setRoleShare(String roleShare) {
        try {
            this.roleShare = Long.valueOf(roleShare);
        }
        catch (NumberFormatException e) {
            this.roleShare = null;
        }
    }

    public String getRoleShare() {
        return this.roleShare == null ? null : this.roleShare.toString();
    }

    public void setPagingOffset(Long pagingOffset) {
        this.pagingOffset = pagingOffset;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = SortColumn.getValidSortColumn(sortColumn);
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public abstract SharedEntitySearchContext getEntitySearchContext();

    public List<ShareTypeRendererBean> getShareTypeRendererBeans() {
        if (this.shareTypes == null) {
            this.shareTypes = new ArrayList<ShareTypeRendererBean>();
            this.shareTypes.add(new ShareTypeRendererBean(this.shareTypeFactory.getShareType(GroupShareType.TYPE), this.authCtx, ShareTypeRenderer.RenderMode.SEARCH, this.entityType));
            this.shareTypes.add(new ShareTypeRendererBean(this.shareTypeFactory.getShareType(ProjectShareType.TYPE), this.authCtx, ShareTypeRenderer.RenderMode.SEARCH, this.entityType));
            if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SHARED_ENTITY_EDIT_RIGHTS)) {
                this.shareTypes.add(new ShareTypeRendererBean(this.shareTypeFactory.getShareType(UserShareType.TYPE), this.authCtx, ShareTypeRenderer.RenderMode.SEARCH, this.entityType));
            }
        }
        return this.shareTypes;
    }

    public String generateSortUrl(String sortColumnName) {
        String actualSortColumn = SortColumn.getValidSortColumn(sortColumnName);
        StringBuffer url = this.createBasicUrlSearchParams();
        this.addParameter(url, "sortColumn", actualSortColumn);
        boolean doSortAscending = true;
        if (actualSortColumn.equalsIgnoreCase(this.getSortColumn())) {
            doSortAscending = !this.isSortAscending();
        } else if (actualSortColumn.equalsIgnoreCase("favcount")) {
            doSortAscending = false;
        }
        this.addParameter(url, "sortAscending", doSortAscending);
        this.addParameter(url, "pagingOffset", 0);
        return url.toString();
    }

    public String generateSortIcon(String sortColumnName) {
        String altText;
        String img;
        String actualSortColumnName = SortColumn.getValidSortColumn(sortColumnName);
        if (!actualSortColumnName.equalsIgnoreCase(this.getSortColumn())) {
            return "";
        }
        if (this.isSortAscending()) {
            img = "icon_sortascending.png";
            altText = this.authCtx.getI18nHelper().getText("navigator.ascending.order");
        } else {
            img = "icon_sortdescending.png";
            altText = this.authCtx.getI18nHelper().getText("navigator.descending.order");
        }
        StringBuilder sb = new StringBuilder("<img class=\"sortArrow\" src=\"");
        if (StringUtils.isNotBlank((CharSequence)this.applicationContext)) {
            sb.append(this.applicationContext);
        }
        sb.append("/images/icons/").append(img).append("\" alt=\"").append(altText).append("\" />");
        return sb.toString();
    }

    public String generateSortCssClass(String sortColumnName) {
        String actualSortColumnName = SortColumn.getValidSortColumn(sortColumnName);
        StringBuilder css = new StringBuilder("colHeaderSortable ");
        if (actualSortColumnName.equalsIgnoreCase(this.getSortColumn())) {
            css.append("colHeaderOver");
        } else {
            css.append("colHeaderLink");
        }
        return css.toString();
    }

    public SearchResult<E> search(JiraServiceContext jiraServiceContext) {
        if (!jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            SharedEntitySearchParameters parameters = this.buildSearchParameters(jiraServiceContext);
            int pagingOffset = this.getSanePagingOffset();
            if (parameters != null && this.validateSearchParameters(jiraServiceContext, parameters, pagingOffset, 20)) {
                SharedEntitySearchResult<E> searchResult = this.doExecuteSearch(jiraServiceContext, parameters, pagingOffset, 20);
                return this.createSearchResults(searchResult, pagingOffset, 20);
            }
        }
        return null;
    }

    public List<E> getPopularFilters(JiraServiceContext jiraServiceContext) {
        SharedEntitySearchParametersBuilder popularSearchParameters = new SharedEntitySearchParametersBuilder();
        popularSearchParameters.setSortColumn(SharedEntityColumn.FAVOURITE_COUNT, false);
        popularSearchParameters.setEntitySearchContext(this.getEntitySearchContext());
        SharedEntitySearchResult<E> sharedEntitySearchResult = this.doExecuteSearch(jiraServiceContext, popularSearchParameters.toSearchParameters(), 0, 20);
        if (sharedEntitySearchResult != null && !jiraServiceContext.getErrorCollection().hasAnyErrors() && !sharedEntitySearchResult.isEmpty()) {
            return sharedEntitySearchResult.getResults();
        }
        return Collections.emptyList();
    }

    public String getSearchShareTypeJSON() {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        if ("group".equalsIgnoreCase(this.getSearchShareType())) {
            jsonMap.put("type", "group");
            if (this.getGroupShare() != null) {
                jsonMap.put("param1", this.getGroupShare());
            }
        } else if ("project".equalsIgnoreCase(this.getSearchShareType())) {
            jsonMap.put("type", "project");
            if (this.getProjectShare() != null) {
                jsonMap.put("param1", this.getProjectShare());
            }
            if (this.getRoleShare() != null) {
                jsonMap.put("param2", this.getRoleShare());
            }
        } else if ("user".equalsIgnoreCase(this.getSearchShareType())) {
            jsonMap.put("type", "user");
            if (this.getUserShare() != null) {
                jsonMap.put("param1", this.getUserShare());
            }
        } else {
            jsonMap.put("type", "any");
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)new JSONObject(jsonMap));
        return jsonArray.toString();
    }

    private SharedEntitySearchParameters buildSearchParameters(JiraServiceContext jiraServiceContext) {
        ApplicationUser currentUser = jiraServiceContext.getLoggedInApplicationUser();
        SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder();
        builder.setName(StringUtils.isBlank((CharSequence)this.getSearchName()) ? null : this.getSearchName());
        builder.setDescription(StringUtils.isBlank((CharSequence)this.getSearchName()) ? null : this.getSearchName());
        builder.setTextSearchMode(SharedEntitySearchParameters.TextSearchMode.OR);
        builder.setSortColumn(this.mapSortColumnToSharedEntityColumn(), this.isSortAscending());
        builder.setEntitySearchContext(this.getEntitySearchContext());
        if (!StringUtils.isBlank((CharSequence)this.getSearchOwnerUserName()) && this.permissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, currentUser)) {
            builder.setUserName(this.getSearchOwnerUserName());
        }
        if (currentUser != null) {
            if ("group".equalsIgnoreCase(this.getSearchShareType())) {
                builder.setShareTypeParameter((ShareTypeSearchParameter)new GroupShareTypeSearchParameter(this.getGroupShare()));
            } else if ("project".equalsIgnoreCase(this.getSearchShareType())) {
                Long projectShareLong = this.asLongOrNull(this.getProjectShare());
                if (projectShareLong == null) {
                    jiraServiceContext.getErrorCollection().addError(ERRORKEY_SHARES, jiraServiceContext.getI18nBean().getText("common.sharing.shared.illegal.search.parameters"));
                    return null;
                }
                builder.setShareTypeParameter((ShareTypeSearchParameter)new ProjectShareTypeSearchParameter(projectShareLong, this.asLongOrNull(this.getRoleShare())));
            } else if ("user".equalsIgnoreCase(this.getSearchShareType())) {
                ApplicationUser user = this.userManager.getUserByName(this.getUserShare());
                builder.setShareTypeParameter((ShareTypeSearchParameter)new UserShareTypeSearchParameter(user == null ? null : user.getKey()));
            }
        }
        return builder.toSearchParameters();
    }

    protected StringBuffer createBasicUrlSearchParams() {
        StringBuffer sb = new StringBuffer().append(this.actionUrlPrefix);
        boolean gotQMark = this.actionUrlPrefix.contains("?");
        sb.append(gotQMark ? "&" : "?");
        sb.append("Search=Search");
        this.addParameter(sb, this.viewParameter, this.viewValue);
        this.addParameter(sb, "searchName", this.getSearchName());
        this.addParameter(sb, "searchOwnerUserName", this.getSearchOwnerUserName());
        this.addParameter(sb, "searchShareType", this.getSearchShareType());
        this.addParameter(sb, "projectShare", this.getProjectShare());
        this.addParameter(sb, "roleShare", this.getRoleShare());
        this.addParameter(sb, "groupShare", this.getGroupShare());
        this.addParameter(sb, "userShare", this.getUserShare());
        return sb;
    }

    protected StringBuffer addParameter(StringBuffer url, String key, Object value) {
        return url.append('&').append(key).append('=').append(this.urlenc(value));
    }

    private String makePagingUrl(int pageNumber) {
        StringBuffer url = this.createBasicUrlSearchParams();
        this.addParameter(url, "pagingOffset", pageNumber);
        this.addParameter(url, "sortAscending", this.isSortAscending());
        this.addParameter(url, "sortColumn", this.getSortColumn());
        return url.toString();
    }

    String urlenc(Object input) {
        if (input == null) {
            return "";
        }
        return JiraUrlCodec.encode((String)input.toString());
    }

    private SharedEntityColumn mapSortColumnToSharedEntityColumn() {
        SharedEntityColumn columnToUse = SharedEntityColumn.NAME;
        if (!StringUtils.isBlank((CharSequence)this.getSortColumn()) && (columnToUse = SORT_COLUMN_TO_SHARED_ENTITY_COLUMN_MAP.get(this.getSortColumn())) == null) {
            columnToUse = SharedEntityColumn.NAME;
        }
        return columnToUse;
    }

    private Long asLongOrNull(String longString) {
        try {
            return Long.valueOf(longString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private int getSanePagingOffset() {
        Long pagingOffset = this.getPagingOffset();
        return pagingOffset == null ? 0 : Math.max(0, pagingOffset.intValue());
    }

    private SearchResult<E> createSearchResults(SharedEntitySearchResult<E> result, int pageOffset, int pageSize) {
        if (result == null) {
            return null;
        }
        if (result.isEmpty()) {
            return SearchResult.emptyResult();
        }
        String nextUrl = result.hasMoreResults() ? this.makePagingUrl(pageOffset + 1) : null;
        String previousUrl = pageOffset > 0 ? this.makePagingUrl(pageOffset - 1) : null;
        int startingResultNo = pageOffset * pageSize;
        int startNo = startingResultNo + 1;
        List filterList = result.getResults();
        int endNo = startingResultNo + filterList.size();
        return new SearchResult(filterList, nextUrl, previousUrl, startNo, endNo, result.getTotalResultCount());
    }

    protected abstract SharedEntitySearchResult<E> doExecuteSearch(JiraServiceContext var1, SharedEntitySearchParameters var2, int var3, int var4);

    protected abstract boolean validateSearchParameters(JiraServiceContext var1, SharedEntitySearchParameters var2, int var3, int var4);

    public static final class SortColumn {
        public static final String FAVCOUNT = "favcount";
        public static final String NAME = "name";
        public static final String OWNER = "owner";
        public static final String DESCRIPTION = "description";
        public static final String DEFAULT_SORT = "name";
        private static final Set<String> COLUMNS;

        public static String getValidSortColumn(String requestedSort) {
            String lowerSort = requestedSort != null ? requestedSort.toLowerCase() : null;
            return !SortColumn.isValid(lowerSort) ? "name" : lowerSort;
        }

        public static boolean isValid(String requestedSort) {
            return requestedSort != null && COLUMNS.contains(requestedSort);
        }

        private SortColumn() {
        }

        static {
            HashSet<String> columns = new HashSet<String>();
            columns.add(FAVCOUNT);
            columns.add("name");
            columns.add(OWNER);
            columns.add(DESCRIPTION);
            COLUMNS = Collections.unmodifiableSet(columns);
        }
    }

    public static final class SearchResult<E> {
        public static final SearchResult<?> EMPTY_RESULTS = new SearchResult(Collections.emptyList(), null, null, -1, -1, -1);
        private final List<E> results;
        private final String nextUrl;
        private final String previousUrl;
        private final int startResultPosition;
        private final int endResultPosition;
        private final int totalResultCount;

        private SearchResult(List<E> results, String nextUrl, String previousUrl, int startResultPosition, int endResultPosition, int totalResultCount) {
            this.results = results;
            this.nextUrl = nextUrl;
            this.previousUrl = previousUrl;
            this.startResultPosition = startResultPosition;
            this.endResultPosition = endResultPosition;
            this.totalResultCount = totalResultCount;
        }

        public List<E> getResults() {
            return this.results;
        }

        public String getNextUrl() {
            return this.nextUrl;
        }

        public String getPreviousUrl() {
            return this.previousUrl;
        }

        public int getStartResultPosition() {
            return this.startResultPosition;
        }

        public int getEndResultPosition() {
            return this.endResultPosition;
        }

        public int getTotalResultCount() {
            return this.totalResultCount;
        }

        public static <E> SearchResult<E> emptyResult() {
            return EMPTY_RESULTS;
        }
    }

    private static final class Search {
        private static final String ANY = "any";
        private static final String GROUP = "group";
        private static final String PROJECT = "project";
        private static final String USER = "user";
        private static final String TYPE = "type";
        private static final String PARAM1 = "param1";
        private static final String PARAM2 = "param2";

        private Search() {
        }
    }
}

