/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.workflow;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;

@LicensedOnly
public class SimpleWorkflowAction
extends AbstractIssueSelectAction {
    private int action;
    private final IssueService issueService;

    public SimpleWorkflowAction(IssueService issueService) {
        this.issueService = issueService;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        IssueService.TransitionValidationResult transitionValidationResult = this.issueService.validateTransition(this.getLoggedInUser(), this.getIssueObject().getId(), this.getAction(), this.issueService.newIssueInputParameters());
        if (!transitionValidationResult.isValid()) {
            this.addErrorCollection(transitionValidationResult.getErrorCollection());
            return "error";
        }
        IssueService.IssueResult transitionResult = this.issueService.transition(this.getLoggedInUser(), transitionValidationResult);
        if (!transitionResult.isValid()) {
            this.addErrorCollection(transitionResult.getErrorCollection());
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.redirectToView();
    }

    private int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }
}

