/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.workflow;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import com.atlassian.jira.web.action.workflow.WorkflowAwareAction;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

@AnonymousSiteAccess
public class WorkflowUIDispatcher
extends AbstractViewIssue
implements WorkflowAwareAction {
    public static final String INVALID_ACTION = "invalidworkflowaction";
    private final IssueWorkflowManager issueWorkflowManager;
    private final WorkflowManager workflowManager;
    private int action;

    public WorkflowUIDispatcher(SubTaskManager subTaskManager, IssueWorkflowManager issueWorkflowManager, WorkflowManager workflowManager) {
        super(subTaskManager);
        this.issueWorkflowManager = issueWorkflowManager;
        this.workflowManager = workflowManager;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        try {
            this.getIssue();
        }
        catch (IssuePermissionException e) {
            return "permissionviolation";
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        if (!this.issueWorkflowManager.isValidAction(this.getIssueObject(), this.action, this.getLoggedInUser())) {
            return INVALID_ACTION;
        }
        WorkflowTransitionUtil workflowTransitionUtil = ComponentManager.getInstance().loadComponent(WorkflowTransitionUtilImpl.class, Collections.emptyList());
        workflowTransitionUtil.setAction(this.action);
        workflowTransitionUtil.setIssue(this.getMutableIssue());
        if (workflowTransitionUtil.hasScreen()) {
            UrlBuilder builder = new UrlBuilder("CommentAssignIssue!default.jspa");
            Map existingParams = ActionContext.getParameters();
            for (Object o : existingParams.keySet()) {
                String[] paramValues;
                String paramName = (String)o;
                if (!StringUtils.isNotBlank((CharSequence)paramName) || "returnUrl".equals(paramName)) continue;
                for (String paramValue : paramValues = (String[])existingParams.get(paramName)) {
                    builder.addParameter(paramName, paramValue);
                }
            }
            return this.forceRedirect(builder.asUrlString());
        }
        return "success";
    }

    private ActionDescriptor getActionDescriptor() {
        Workflow wf = this.workflowManager.makeWorkflow(this.getLoggedInUser());
        long workflowId = this.getIssue().getLong("workflowId");
        WorkflowDescriptor wd = wf.getWorkflowDescriptor(wf.getWorkflowName(workflowId));
        return wd.getAction(this.action);
    }

    @Override
    public String getWorkflowTransitionDisplayName() {
        return this.getWorkflowTransitionDisplayName(this.getActionDescriptor());
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }
}

