/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.model.WebPanel;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WorkflowHeaderWebComponent {
    private final WebInterfaceManager webInterfaceManager;
    private final ProjectWorkflowSchemeHelper helper;
    private final VelocityParamFactory velocityParamFactory;

    public WorkflowHeaderWebComponent(WebInterfaceManager webInterfaceManager, ProjectWorkflowSchemeHelper helper, VelocityParamFactory velocityParamFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.helper = helper;
        this.velocityParamFactory = velocityParamFactory;
    }

    public String getHtml(JiraWorkflow jiraWorkflow, String helpPath, Long projectId) {
        WebPanel first = (WebPanel)Iterables.getFirst((Iterable)this.webInterfaceManager.getWebPanels("workflow.header"), null);
        if (first != null) {
            HashMap context = Maps.newHashMap();
            context.put("jiraWorkflow", jiraWorkflow);
            context.put("active", true);
            context.put("helpUtil", HelpUtil.getInstance());
            context.put("sharedProjects", this.helper.getProjectsForWorkflow(jiraWorkflow.getName()));
            context.put("projectId", projectId);
            context.put("issueTypeId", WorkflowHeaderWebComponent.getIssueTypeFromRequest());
            context.put("helpPath", HelpUtil.getInstance().getHelpPath(helpPath));
            context.put("displayUpdatedDate", WorkflowHeaderWebComponent.shouldDisplayUpdatedDate());
            return first.getHtml(this.velocityParamFactory.getDefaultVelocityParams((Map)context));
        }
        return "";
    }

    public String getHtml(JiraWorkflow jiraWorkflow, String helpPath) {
        return this.getHtml(jiraWorkflow, helpPath, null);
    }

    public String getLinksHtml(JiraWorkflow workflow, Long projectId, String viewMode, boolean editable) {
        HashMap context = Maps.newHashMap();
        context.put("workflow", workflow);
        context.put("issueTypeId", WorkflowHeaderWebComponent.getIssueTypeFromRequest());
        context.put("project", projectId);
        context.put("wfName", JiraUrlCodec.encode((String)workflow.getName()));
        context.put("wfMode", JiraUrlCodec.encode((String)workflow.getMode()));
        context.put("viewMode", viewMode);
        context.put("editable", editable);
        VelocityTemplatingEngine velocityEngine = (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
        return velocityEngine.render(TemplateSources.file((String)"/templates/jira/admin/view-workflow-links.vm")).applying(this.velocityParamFactory.getDefaultVelocityParams((Map)context)).asHtml();
    }

    private static String getIssueTypeFromRequest() {
        String issueType;
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null && (issueType = request.getParameter("issueType")) != null) {
            return JiraUrlCodec.encode((String)issueType);
        }
        return null;
    }

    private static boolean shouldDisplayUpdatedDate() {
        String requestURI;
        boolean shouldDisplayUpdatedDate = false;
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null && (requestURI = request.getRequestURI()) != null) {
            shouldDisplayUpdatedDate = WorkflowHeaderWebComponent.isUriForClassicOrTextMode(requestURI);
        }
        return shouldDisplayUpdatedDate;
    }

    private static boolean isUriForClassicOrTextMode(String uri) {
        return !uri.endsWith("/WorkflowDesigner.jspa");
    }
}

