/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.webfragment;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.webfragment.ContextLayoutBean;
import com.atlassian.jira.web.util.AccessKeyHelperImpl;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import java.util.List;
import java.util.Map;

public class WebFragmentWebComponent
extends AbstractWebComponent {
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SimpleLinkManager simpleLinkManager;

    public WebFragmentWebComponent(DynamicWebInterfaceManager webInterfaceManager, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, SimpleLinkManager simpleLinkManager) {
        super(templatingEngine, applicationProperties);
        this.webInterfaceManager = webInterfaceManager;
        this.authenticationContext = authenticationContext;
        this.simpleLinkManager = simpleLinkManager;
    }

    public String getHtml(String template, String location, JiraHelper jiraHelper) {
        return this.getHtml(template, location, jiraHelper, null);
    }

    public String getHtml(String template, String location, JiraHelper jiraHelper, ContextLayoutBean layoutBean) {
        return this.getHtml(template, this.getDefaultParams(this.makeContext(location, this.authenticationContext.getUser(), jiraHelper, layoutBean, this.authenticationContext.getI18nHelper())));
    }

    private Map<String, Object> makeContext(String location, ApplicationUser remoteUser, JiraHelper jiraHelper, ContextLayoutBean layoutBean, I18nHelper i18n) {
        return MapBuilder.newBuilder((Object)"webInterfaceManager", (Object)this.webInterfaceManager).add((Object)"linkManager", (Object)this.simpleLinkManager).add((Object)"location", (Object)location).add((Object)"user", (Object)remoteUser).add((Object)"helper", (Object)jiraHelper).add((Object)"i18n", (Object)i18n).add((Object)"accessKeyHelper", (Object)new AccessKeyHelperImpl()).add((Object)"layout", (Object)layoutBean).toMap();
    }

    private Map<String, Object> getDefaultParams(Map<String, Object> startingParams) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
    }

    public boolean hasDisplayableItems(String location, JiraHelper jiraHelper) {
        ApplicationUser remoteUser = this.authenticationContext.getUser();
        if (!this.simpleLinkManager.getLinksForSection(location, remoteUser, jiraHelper).isEmpty()) {
            return true;
        }
        List displayableSections = this.simpleLinkManager.getSectionsForLocation(location, remoteUser, jiraHelper);
        for (SimpleLinkSection section : displayableSections) {
            if (this.simpleLinkManager.getLinksForSection(location + "/" + section.getId(), remoteUser, jiraHelper).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

