/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.dispatcher.ActionViewDataSupport;
import com.atlassian.jira.web.dispatcher.JiraWebworkViewDispatcher;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.VelocityException;
import webwork.config.util.ActionInfo;
import webwork.dispatcher.ActionResult;
import webwork.view.velocity.VelocityHelper;

class JiraVelocityViewDispatcher {
    private final ActionViewDataSupport actionViewDataSupport = new ActionViewDataSupport();

    JiraVelocityViewDispatcher() {
    }

    public void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionResult actionResult, ActionInfo.ViewInfo viewInfo) throws ServletException, IOException {
        String templatePath = this.buildTemplatePath(actionResult, viewInfo);
        PrintWriter writer = httpServletResponse.getWriter();
        try {
            VelocityContext context = this.buildActionVelocityContext(httpServletRequest, httpServletResponse, actionResult, viewInfo);
            this.getTemplatingEngine().render(TemplateSources.file((String)templatePath)).applying(context).asHtml((Writer)writer);
        }
        catch (VelocityException e) {
            this.errorHandling(templatePath, writer, e);
        }
    }

    private String buildTemplatePath(ActionResult actionResult, ActionInfo.ViewInfo viewInfo) {
        String pluginSource = viewInfo.getActionInfo().getSource();
        Object pluginPrefix = JiraWebworkViewDispatcher.isFromCore(pluginSource) ? "" : pluginSource + "/";
        return (String)pluginPrefix + actionResult.getView().toString();
    }

    private void errorHandling(String templatePath, PrintWriter writer, VelocityException e) {
        writer.write("Exception rendering velocity file " + TextUtils.htmlEncode((String)templatePath));
        writer.write("<br><pre>");
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        writer.write(TextUtils.htmlEncode((String)stringWriter.toString()));
        writer.write("</pre>");
    }

    private VelocityContext buildActionVelocityContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionResult actionResult, ActionInfo.ViewInfo viewInfo) {
        ActionContextKit.setContext(httpServletRequest, httpServletResponse, ServletContextProvider.getServletContext());
        Map<String, Object> velocityParams = this.getDefaultVelocityParams();
        velocityParams.put("i18n", this.getAuthenticationContext().getI18nHelper());
        velocityParams.putAll(this.actionViewDataSupport.getData(actionResult, viewInfo));
        return (VelocityContext)VelocityHelper.getContextWithoutInit((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, velocityParams);
    }

    @VisibleForTesting
    Map<String, Object> getDefaultVelocityParams() {
        return JiraVelocityUtils.getDefaultVelocityParams(this.getAuthenticationContext());
    }

    @VisibleForTesting
    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }
}

