/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import java.io.IOException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@UnrestrictedAccess
public class MultipartBoundaryCheckFilter
implements Filter {
    private static final int CONTENT_TYPE_BOUNDARY_LENGTH_LIMIT = 70;
    private static final String MULTIPART = "multipart";
    private static final String FORM_DATA = "form-data";
    private static final String BOUNDARY = "boundary";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String boundary;
        String contentType = request.getContentType();
        if (contentType != null && this.isMultiPartBoundary(contentType) && ((boundary = this.getMultiPartBoundary(contentType)) == null || boundary.length() > 70)) {
            throw new RuntimeException("Error parsing Content-Type header");
        }
        chain.doFilter(request, response);
    }

    private boolean isMultiPartBoundary(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.contains(MULTIPART) && contentType.contains(FORM_DATA) && contentType.contains(BOUNDARY);
    }

    private String getMultiPartBoundary(String contentType) {
        if (contentType.contains(BOUNDARY)) {
            try {
                return new ContentType(contentType).getParameter(BOUNDARY);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

