/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.web.filters.ServletContextRegistrar;
import com.atlassian.jira.web.filters.security.AccessCheckFilter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServletFilterRegistrar
implements ServletContextRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ServletFilterRegistrar.class);
    private final String filterName;
    private final Class<? extends Filter> filterClass;
    private final Map<String, String> initParams;
    private final Collection<Mapping> mappings;

    private ServletFilterRegistrar(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParams, Collection<Mapping> mappings) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        this.initParams = initParams;
        this.mappings = mappings;
    }

    @Override
    public void register(ServletContext servletContext) throws ServletException {
        Filter wrappedFilter;
        try {
            wrappedFilter = AccessCheckFilter.maybeWrap(this.filterClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        FilterRegistration.Dynamic reg = servletContext.addFilter(this.filterName, wrappedFilter);
        if (reg == null) {
            throw new ServletException("ServletContext already contains a complete registration for filter " + this.filterName);
        }
        log.info("Registering filter '{}' with init-params {}", (Object)this.filterName, this.initParams);
        reg.setInitParameters(this.initParams);
        for (Mapping mapping : this.mappings) {
            log.info("Mapping filter '{}' to url-patterns {}", (Object)this.filterName, (Object)mapping.getUrlPatterns());
            mapping.addTo(reg);
        }
    }

    static Builder filter(String filterName, Class<? extends Filter> filter) {
        return new Builder().filterName(filterName).filter(filter);
    }

    private static class Mapping {
        private final EnumSet<DispatcherType> dispatcherTypes;
        private final String[] patterns;

        Mapping(EnumSet<DispatcherType> dispatcherTypes, String ... urlPatterns) {
            this.dispatcherTypes = dispatcherTypes;
            this.patterns = urlPatterns;
        }

        void addTo(FilterRegistration.Dynamic reg) {
            reg.addMappingForUrlPatterns(this.dispatcherTypes, false, this.patterns);
        }

        String[] getUrlPatterns() {
            return this.patterns;
        }
    }

    static class Builder {
        private String filterName;
        private Class<? extends Filter> filterClass;
        private final Map<String, String> initParams = new LinkedHashMap<String, String>();
        private final Collection<Mapping> mappings = new LinkedList<Mapping>();

        Builder() {
        }

        Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        Builder filter(Class<? extends Filter> filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        Builder initParam(String name, String value) {
            this.initParams.put(name, value);
            return this;
        }

        Builder location(String value) {
            return this.initParam("location", value);
        }

        Builder dispatcher(DispatcherType value) {
            return this.initParam("dispatcher", value.name());
        }

        Builder mapping(String ... urlPatterns) {
            return this.mapping(EnumSet.of(DispatcherType.REQUEST), urlPatterns);
        }

        Builder mapping(EnumSet<DispatcherType> dispatcherTypes, String ... urlPatterns) {
            this.mappings.add(new Mapping(dispatcherTypes, urlPatterns));
            return this;
        }

        ServletFilterRegistrar build() {
            return new ServletFilterRegistrar(this.filterName, this.filterClass, this.initParams, this.mappings);
        }
    }
}

