/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.security.JiraSecurityFilter;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationFilter;
import com.atlassian.jira.security.xsrf.XsrfTokenAdditionRequestFilter;
import com.atlassian.jira.servermetrics.CorrelationIdPopulatorFilter;
import com.atlassian.jira.servermetrics.MetricsCollectorFilter;
import com.atlassian.jira.web.filters.CommittedResponseHtmlErrorRecoveryFilter;
import com.atlassian.jira.web.filters.JIRAProfilingFilter;
import com.atlassian.jira.web.filters.JiraCachingFilter;
import com.atlassian.jira.web.filters.JiraFirstFilter;
import com.atlassian.jira.web.filters.JiraImportProgressFilter;
import com.atlassian.jira.web.filters.JiraLastFilter;
import com.atlassian.jira.web.filters.JiraLoginFilter;
import com.atlassian.jira.web.filters.JiraPostEncodingFilter;
import com.atlassian.jira.web.filters.JiraStaticAssetsFilter;
import com.atlassian.jira.web.filters.MauEventFilter;
import com.atlassian.jira.web.filters.MobileAppRequestFilter;
import com.atlassian.jira.web.filters.MultipartBoundaryCheckFilter;
import com.atlassian.jira.web.filters.NotFoundFilter;
import com.atlassian.jira.web.filters.PathMatchingEncodingFilter;
import com.atlassian.jira.web.filters.ServletContextRegistrar;
import com.atlassian.jira.web.filters.ServletFilterRegistrar;
import com.atlassian.jira.web.filters.SetupProgressFilter;
import com.atlassian.jira.web.filters.SitemeshPageFilter;
import com.atlassian.jira.web.filters.StartupProgressFilter;
import com.atlassian.jira.web.filters.SvgToPngTranscoderFilter;
import com.atlassian.jira.web.filters.UnrestrictedAccessHeaderSanitisingFilter;
import com.atlassian.jira.web.filters.UnrestrictedAccessUrlRewriteFilter;
import com.atlassian.jira.web.filters.accesslog.AccessLogFilter;
import com.atlassian.jira.web.filters.annotations.ServletSecurityAnnotationsFilter;
import com.atlassian.jira.web.filters.gzip.JiraGzipFilter;
import com.atlassian.jira.web.filters.johnson.JiraJohnson503Filter;
import com.atlassian.jira.web.filters.johnson.JiraJohnsonFilter;
import com.atlassian.jira.web.filters.mau.MauRequestTaggingFilter;
import com.atlassian.jira.web.filters.pagebuilder.PageBuilderFilter;
import com.atlassian.jira.web.filters.security.ServletFilterModuleContainerFilter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

enum ServletFilters {
    JIRA_IMPORT_PROGRESS_FILTER(ServletFilterRegistrar.filter("JiraImportProgressFilter", JiraImportProgressFilter.class).mapping("/importprogress")),
    SETUP_PROGRESS_FILTER(ServletFilterRegistrar.filter("SetupProgressFilter", SetupProgressFilter.class).mapping("/setupprogress")),
    STARTUP_PROGRESS_FILTER(ServletFilterRegistrar.filter("StartupProgressFilter", StartupProgressFilter.class).mapping("/startup.jsp")),
    GZIP_FILTER(ServletFilterRegistrar.filter("gzip", JiraGzipFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR), "/*")),
    JIRA_FIRST_FILTER(ServletFilterRegistrar.filter("JiraFirstFilter", JiraFirstFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR), "/*")),
    METRICS_COLLECTOR_FILTER(ServletFilterRegistrar.filter("MetricsCollectorFilter", MetricsCollectorFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), "/*")),
    MULTIPART_BOUNDARY_CHECK_FILTER(ServletFilterRegistrar.filter("MultipartBoundaryCheckFilter", MultipartBoundaryCheckFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR), "/*")),
    ALWAYS_RETURN_NOT_FOUND(ServletFilterRegistrar.filter("AlwaysReturnNotFound", NotFoundFilter.class).mapping("*.vm", "*.vmd", "*.vtl")),
    JIRA_STATIC_ASSETS_FILTER(ServletFilterRegistrar.filter("JiraStaticAssetsFilter", JiraStaticAssetsFilter.class).mapping("/static-assets/*", "/secure/better-johnson/build/*")),
    ENCODING(ServletFilterRegistrar.filter("encoding", PathMatchingEncodingFilter.class).mapping("/*")),
    CACHING(ServletFilterRegistrar.filter("caching", JiraCachingFilter.class).mapping("/*")),
    POSTENCODING(ServletFilterRegistrar.filter("postencoding", JiraPostEncodingFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR), "/*")),
    PLUGIN_DISPATCHER_AFTER_ENCODING_REQUEST(ServletFilterRegistrar.filter("filter-plugin-dispatcher-after-encoding-request", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/*").location("after-encoding").dispatcher(DispatcherType.REQUEST)),
    PLUGIN_DISPATCHER_AFTER_ENCODING_FORWARD(ServletFilterRegistrar.filter("filter-plugin-dispatcher-after-encoding-forward", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.FORWARD), "/*").location("after-encoding").dispatcher(DispatcherType.FORWARD)),
    PLUGIN_DISPATCHER_AFTER_ENCODING_INCLUDE(ServletFilterRegistrar.filter("filter-plugin-dispatcher-after-encoding-include", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.INCLUDE), "/*").location("after-encoding").dispatcher(DispatcherType.INCLUDE)),
    PLUGIN_DISPATCHER_AFTER_ENCODING_ERROR(ServletFilterRegistrar.filter("filter-plugin-dispatcher-after-encoding-error", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.ERROR), "/*").location("after-encoding").dispatcher(DispatcherType.ERROR)),
    CORRELATION_ID_POPULATOR_FILTER(ServletFilterRegistrar.filter("CorrelationIdPopulatorFilter", CorrelationIdPopulatorFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), "/*")),
    URL_REWRITE_FILTER(ServletFilterRegistrar.filter("UrlRewriteFilter", UnrestrictedAccessUrlRewriteFilter.class).mapping("/*")),
    CONSISTENCY(ServletFilterRegistrar.filter("consistency", JiraJohnsonFilter.class).mapping("*.jsp", "*.jspa", "/browse/*", "/logout", "*.vm", "/issues/*", "/auditing/*", "/i")),
    CONSISTENCY_503(ServletFilterRegistrar.filter("consistency503", JiraJohnson503Filter.class).mapping("/*")),
    PROFILING(ServletFilterRegistrar.filter("profiling", JIRAProfilingFilter.class).mapping("*.jsp", "*.jspa", "/browse/*", "/si/*", "/sr/*", "/plugins/servlet/*").initParam("activate.param", "jira_profile").initParam("autostart", "false")),
    PLUGIN_DISPATCHER_BEFORE_LOGIN_REQUEST(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-login-request", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/*").location("before-login").dispatcher(DispatcherType.REQUEST)),
    PLUGIN_DISPATCHER_BEFORE_LOGIN_FORWARD(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-login-forward", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.FORWARD), "/*").location("before-login").dispatcher(DispatcherType.FORWARD)),
    PLUGIN_DISPATCHER_BEFORE_LOGIN_INCLUDE(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-login-include", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.INCLUDE), "/*").location("before-login").dispatcher(DispatcherType.INCLUDE)),
    PLUGIN_DISPATCHER_BEFORE_LOGIN_ERROR(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-login-error", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.ERROR), "/*").location("before-login").dispatcher(DispatcherType.ERROR)),
    LOGIN(ServletFilterRegistrar.filter("login", JiraLoginFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), "/*")),
    TRUSTED_APPS(ServletFilterRegistrar.filter("trustedapps", TrustedApplicationFilter.class).mapping("/*")),
    SECURITY(ServletFilterRegistrar.filter("security", JiraSecurityFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), "/*")),
    SECURITY_ANNOTATIONS(ServletFilterRegistrar.filter("securityAnnotations", ServletSecurityAnnotationsFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), "/*")),
    MAU_EVENT(ServletFilterRegistrar.filter("mauevent", MauEventFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/*")),
    MAU_FAMILY_EVENT_TAGGER(ServletFilterRegistrar.filter("maufamilyeventtagger", MauRequestTaggingFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/rest/gadget/*", "/rest/dashboards/*", "/rest/issueNav/*", "/secure/admin/*", "/secure/project/ViewProjects.jspa").initParam("mauApplicationKey", "family")),
    XSRF_TOKEN_ADDITION(ServletFilterRegistrar.filter("xsrf-token-addition", XsrfTokenAdditionRequestFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/*")),
    PLUGIN_DISPATCHER_BEFORE_DECORATION_REQUEST(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-decoration-request", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/*").location("before-decoration").dispatcher(DispatcherType.REQUEST)),
    PLUGIN_DISPATCHER_BEFORE_DECORATION_FORWARD(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-decoration-forward", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.FORWARD), "/*").location("before-decoration").dispatcher(DispatcherType.FORWARD)),
    PLUGIN_DISPATCHER_BEFORE_DECORATION_INCLUDE(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-decoration-include", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.INCLUDE), "/*").location("before-decoration").dispatcher(DispatcherType.INCLUDE)),
    PLUGIN_DISPATCHER_BEFORE_DECORATION_ERROR(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-decoration-error", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.ERROR), "/*").location("before-decoration").dispatcher(DispatcherType.ERROR)),
    COMMITTED_RESPONSE_HTML_ERROR_RECOVERY_FILTER(ServletFilterRegistrar.filter("committedResponseHtmlErrorRecoveryFilter", CommittedResponseHtmlErrorRecoveryFilter.class).mapping("/*")),
    PAGE_BUILDER_FILTER(ServletFilterRegistrar.filter("pageBuilderFilter", PageBuilderFilter.class).mapping(EnumSet.of(DispatcherType.FORWARD, DispatcherType.REQUEST), "/*")),
    SITE_MESH(ServletFilterRegistrar.filter("sitemesh", SitemeshPageFilter.class).mapping(EnumSet.of(DispatcherType.FORWARD, DispatcherType.REQUEST), "*.jsp").mapping("/logout.jsp", "/login.jsp", "/secure/*", "/view/*", "/browse/*", "/plugins/servlet/*", "/issues/*", "/i").initParam("exclude.paths", "/secure/attachment, /secure/temporaryattachment, /secure/thumbnail, /secure/applet*").initParam("exclude.headers", "X-PJAX, X-SITEMESH-OFF")),
    SVG_TO_PNG_TRANSCODER(ServletFilterRegistrar.filter("svg-to-png-transcoder", SvgToPngTranscoderFilter.class).mapping("/images/*")),
    ACCESS_FILTER(ServletFilterRegistrar.filter("access", AccessLogFilter.class).mapping("/*")),
    MOBILE_APP_REQUEST_FILTER(ServletFilterRegistrar.filter("mobile-app-request-filter", MobileAppRequestFilter.class).mapping("/*")),
    PLUGIN_DISPATCHER_BEFORE_DISPATCH_REQUEST(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-dispatch-request", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST), "/*").location("before-dispatch").dispatcher(DispatcherType.REQUEST)),
    PLUGIN_DISPATCHER_BEFORE_DISPATCH_FORWARD(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-dispatch-forward", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.FORWARD), "/*").location("before-dispatch").dispatcher(DispatcherType.FORWARD)),
    PLUGIN_DISPATCHER_BEFORE_DISPATCH_INCLUDE(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-dispatch-include", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.INCLUDE), "/*").location("before-dispatch").dispatcher(DispatcherType.INCLUDE)),
    PLUGIN_DISPATCHER_BEFORE_DISPATCH_ERROR(ServletFilterRegistrar.filter("filter-plugin-dispatcher-before-dispatch-error", ServletFilterModuleContainerFilter.class).mapping(EnumSet.of(DispatcherType.ERROR), "/*").location("before-dispatch").dispatcher(DispatcherType.ERROR)),
    HEADER_SANITISING(ServletFilterRegistrar.filter("headersanitising", UnrestrictedAccessHeaderSanitisingFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR), "/*")),
    JIRA_LAST_FILTER(ServletFilterRegistrar.filter("JiraLastFilter", JiraLastFilter.class).mapping(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), "/*"));

    private final ServletContextRegistrar registrar;

    private ServletFilters(ServletContextRegistrar registrar) {
        this.registrar = registrar;
    }

    private ServletFilters(ServletFilterRegistrar.Builder builder) {
        this(builder.build());
    }

    static void registerAll(ServletContext servletContext) throws ServletException {
        for (ServletFilters filter : ServletFilters.values()) {
            filter.registrar.register(servletContext);
        }
    }
}

