/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.web.filters.ServletFilters;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import javax.servlet.Registration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletsInitializer {
    private static final Logger log = LoggerFactory.getLogger(ServletsInitializer.class);

    public void onStartup(ServletContext servletContext) throws ServletException {
        List<String> nonTomcatFilters = servletContext.getFilterRegistrations().values().stream().map(Registration::getClassName).filter(filterClassName -> !filterClassName.startsWith("org.apache.tomcat.")).toList();
        Preconditions.checkState((boolean)nonTomcatFilters.isEmpty(), (String)"All Jira Core servlet filters should be registered in %s. Remove configuration for the following filters from web.xml: %s", (Object)ServletFilters.class.getName(), nonTomcatFilters);
        log.debug("Registering filters in servlet context");
        ServletFilters.registerAll(servletContext);
        Set registeredFilters = servletContext.getFilterRegistrations().keySet();
        log.debug("Registered {} filters in servlet context: {}", (Object)registeredFilters.size(), registeredFilters);
    }
}

