/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.setup.AsynchronousJiraSetup;
import com.atlassian.jira.setup.AsynchronousJiraSetupFactory;
import com.atlassian.jira.setup.InstantSetupStrategy;
import com.atlassian.jira.setup.SetupStrategy;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class SetupProgressFilter
extends AbstractHttpFilter {
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            JSONObject json = new JSONObject();
            response.setContentType("application/json");
            String sessionId = (String)request.getSession().getAttribute("setup-session-id");
            InstantSetupStrategy.Step step = InstantSetupStrategy.Step.valueOf(request.getParameter("askingAboutStep").toUpperCase());
            this.populateJsonWithSetupStatus(json, AsynchronousJiraSetupFactory.getInstance().getStatusOnceStepIsDone(sessionId, step));
            String result = json.toString();
            response.getWriter().write(result);
            response.getWriter().flush();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void populateJsonWithSetupStatus(JSONObject json, AsynchronousJiraSetup.SetupStatus<InstantSetupStrategy.Step> setupStatus) throws JSONException {
        JSONObject stepsJson = new JSONObject();
        json.put("steps", (Object)stepsJson);
        for (InstantSetupStrategy.Step step : setupStatus.getSteps().keySet()) {
            stepsJson.put(step.name().toLowerCase(), (Object)((SetupStrategy.Status)((Object)setupStatus.getSteps().get((Object)step))).name().toLowerCase());
        }
        String errorMessage = setupStatus.getError();
        if (errorMessage != null) {
            json.put("errorMessage", (Object)errorMessage);
        }
    }
}

