/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.web.filters.InitParamSupport;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public final class SitemeshPageFilter
extends SiteMeshFilter {
    private static final String SEPARATOR = ",";
    private static final String WILDCARD = "*";
    private static final String INIT_LOG_MSG = "PathExclusionFilter [%s] initialized, \nHeader names: %s\nExact exclude patterns: %s\nWildcard exclude patterns: %s";
    private static final String FILTER_LOG_MSG = "PathExclusionFilter[%s].filter decorated filter %s for servlet path [%s] ";
    private static final Logger log = LoggerFactory.getLogger(SitemeshPageFilter.class);
    private String name;
    private final Set<String> excludedExactPatterns = new LinkedHashSet<String>();
    private final Set<String> excludedWildcardPatterns = new LinkedHashSet<String>();
    private final AtomicReference<ImmutableSet<String>> excludedHeaderNames = new AtomicReference();

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.name = filterConfig.getFilterName();
        this.parseExcludedPaths(InitParams.EXCLUDED_PATHS.get(filterConfig));
        this.excludedHeaderNames.set(this.parseExcludeHeaderNames(InitParams.EXCLUDED_HEADERS.get(filterConfig)));
        this.logInit();
    }

    public void doFilter(ServletRequest requestz, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isExcluded;
        HttpServletRequest httpRequest = (HttpServletRequest)requestz;
        boolean bl = isExcluded = this.hasExcludeHeader(httpRequest) || this.isExcluded(httpRequest.getServletPath());
        if (log.isDebugEnabled()) {
            log.debug(String.format(FILTER_LOG_MSG, this.name, this.excludedMsg(isExcluded), httpRequest.getServletPath()));
        }
        if (isExcluded) {
            chain.doFilter((ServletRequest)httpRequest, response);
        } else {
            super.doFilter((ServletRequest)httpRequest, response, chain);
        }
    }

    public void destroy() {
        super.destroy();
    }

    private boolean hasExcludeHeader(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!this.excludedHeaderNames.get().contains((Object)headerName.toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String servletPath) {
        return this.matchesExact(servletPath) || this.matchesWildcard(servletPath);
    }

    private boolean matchesExact(String servletPath) {
        return this.excludedExactPatterns.contains(servletPath);
    }

    private boolean matchesWildcard(String servletPath) {
        for (String wildcardPattern : this.excludedWildcardPatterns) {
            if (!servletPath.startsWith(wildcardPattern)) continue;
            return true;
        }
        return false;
    }

    private void parseExcludedPaths(String pathsParamValue) {
        if (StringUtils.isBlank((CharSequence)pathsParamValue)) {
            log.warn("No excluded paths configured for filter '{}'", (Object)this.name);
            return;
        }
        for (String path : pathsParamValue.split(SEPARATOR)) {
            this.addToPaths(path.trim());
        }
    }

    private ImmutableSet<String> parseExcludeHeaderNames(String headerNames) {
        if (StringUtils.isBlank((CharSequence)headerNames)) {
            log.warn("No excluded paths configured for filter '{}'", (Object)this.name);
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(StringUtils.split((String)headerNames, (String)SEPARATOR)), (Function)new Function<String, String>(){

            public String apply(@Nullable String from) {
                return from != null ? from.trim().toLowerCase(Locale.US) : null;
            }
        }));
    }

    private void addToPaths(String path) {
        if (this.hasWildcardPattern(path)) {
            this.excludedWildcardPatterns.add(this.removeWildcard(path));
        } else {
            this.excludedExactPatterns.add(path);
        }
    }

    private boolean hasWildcardPattern(String path) {
        return path.endsWith(WILDCARD);
    }

    private String removeWildcard(String pathPattern) {
        return pathPattern.substring(0, pathPattern.length() - WILDCARD.length());
    }

    private void logInit() {
        if (log.isDebugEnabled()) {
            log.debug(String.format(INIT_LOG_MSG, this.name, this.excludedExactPatterns, this.excludedWildcardPatterns, this.excludedHeaderNames));
        }
    }

    private String excludedMsg(boolean excluded) {
        return excluded ? "EXCLUDED" : "ACCEPTED";
    }

    public static enum InitParams {
        EXCLUDED_PATHS(InitParamSupport.required("exclude.paths")),
        EXCLUDED_HEADERS(InitParamSupport.optional("exclude.headers"));

        private final InitParamSupport support;

        private InitParams(InitParamSupport support) {
            this.support = support;
        }

        public String key() {
            return this.support.key();
        }

        String get(FilterConfig config) {
            return this.support.get(config);
        }
    }
}

