/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.web.filters.accesslog.AccessLogIPAddressUtil;
import com.atlassian.jira.web.filters.accesslog.AtlassianSessionIdUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class AccessLogRequestInfo {
    public static final String JIRA_REQUEST_USER_NAME = "jira.request.username";
    public static final String JIRA_REQUEST_START_MILLIS = "jira.request.start.millis";
    public static final String JIRA_REQUEST_TIME_MICROS = "jira.request.time.micros";
    public static final String JIRA_REQUEST_ID = "jira.request.id";
    public static final String JIRA_REQUEST_ASESSIONID = "jira.request.assession.id";
    public static final String JIRA_SESSION_LAST_ACCESSED_TIME = "jira.session.last.accessed.time";
    public static final String JIRA_SESSION_MAX_INACTIVE_INTERVAL = "jira.session.max.inactive.interval";
    public static final String X_ASESSIONID_HEADER = "X-ASESSIONID";
    public static final String X_REQUESTID_HEADER = "X-AREQUESTID";
    public static final String X_NODEID_HEADER = "X-ANODEID";
    public static final String X_USER_NAME_HEADER = "X-AUSERNAME";
    public static final AtomicLong requestCounter = new AtomicLong(0L);
    public static final AtomicLong concurrentRequests = new AtomicLong(0L);
    private static final Pattern osPasswordRegex = Pattern.compile("os_password=[^&]+");
    public static final String OS_PASSWORD = "os_password";
    public static final String OS_PASSWORD_SANITIZED = "os_password=***";
    public static final String SANITIZED_QUERY = "sanitized.query";
    public static final String SANITIZED_REFERER = "sanitized.referer";
    private static final String EXIT_CALLED = AccessLogRequestInfo.class.getName() + "exit.called";

    public void enterRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest.getAttribute(JIRA_REQUEST_START_MILLIS) == null) {
            httpServletRequest.setAttribute(JIRA_REQUEST_START_MILLIS, (Object)System.currentTimeMillis());
            long concurrentCount = concurrentRequests.incrementAndGet();
            long requestCount = requestCounter.incrementAndGet();
            String requestId = this.generateUniqueRequestId(requestCount, concurrentCount);
            String atlassianSessionId = AtlassianSessionIdUtil.generateAtlassianSessionHash(httpServletRequest, httpServletResponse);
            httpServletRequest.setAttribute(JIRA_REQUEST_ID, (Object)requestId);
            httpServletRequest.setAttribute(JIRA_REQUEST_ASESSIONID, (Object)atlassianSessionId);
            httpServletRequest.setAttribute(JIRA_REQUEST_USER_NAME, null);
            this.setHeader(httpServletResponse, X_REQUESTID_HEADER, requestId);
            this.setHeader(httpServletResponse, X_ASESSIONID_HEADER, atlassianSessionId);
            this.recordNodeInformation(httpServletResponse);
            this.recordLog4JInformation(httpServletRequest, requestId, atlassianSessionId);
            this.recordSessionInformation(httpServletRequest);
            this.examineCookies(httpServletRequest);
            this.sanitizeOsPasswordInQueryParams(httpServletRequest);
            this.sanitizeOsPasswordInRefererHeader(httpServletRequest);
        }
        if (httpServletRequest.getAttribute(JIRA_REQUEST_ASESSIONID) == null) {
            String atlassianSessionId = AtlassianSessionIdUtil.generateAtlassianSessionHash(httpServletRequest, httpServletResponse);
            httpServletRequest.setAttribute(JIRA_REQUEST_ASESSIONID, (Object)atlassianSessionId);
            this.setHeader(httpServletResponse, X_ASESSIONID_HEADER, atlassianSessionId);
            Log4jKit.putASessionIdToMDC(atlassianSessionId);
        }
    }

    private void sanitizeOsPasswordInQueryParams(HttpServletRequest httpServletRequest) {
        String query = httpServletRequest.getQueryString();
        if (null != query && !query.trim().isEmpty()) {
            if (query.contains(OS_PASSWORD)) {
                httpServletRequest.setAttribute(SANITIZED_QUERY, (Object)("?" + osPasswordRegex.matcher(query).replaceAll(OS_PASSWORD_SANITIZED)));
            } else {
                httpServletRequest.setAttribute(SANITIZED_QUERY, (Object)("?" + query));
            }
        } else {
            httpServletRequest.setAttribute(SANITIZED_QUERY, (Object)"");
        }
    }

    private void sanitizeOsPasswordInRefererHeader(HttpServletRequest httpServletRequest) {
        String referer = httpServletRequest.getHeader("Referer");
        if (null != referer && !referer.trim().isEmpty()) {
            if (referer.contains(OS_PASSWORD)) {
                httpServletRequest.setAttribute(SANITIZED_REFERER, (Object)osPasswordRegex.matcher(referer).replaceAll(OS_PASSWORD_SANITIZED));
            } else {
                httpServletRequest.setAttribute(SANITIZED_REFERER, (Object)referer);
            }
        }
    }

    private void recordNodeInformation(HttpServletResponse httpServletResponse) {
        ClusterManager clusterManager = ComponentAccessor.getComponentSafely(ClusterManager.class).orElse(null);
        if (clusterManager != null && clusterManager.isClustered()) {
            this.setHeader(httpServletResponse, X_NODEID_HEADER, clusterManager.getNodeId());
        }
    }

    public void exitRequest(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute(EXIT_CALLED) == null) {
            concurrentRequests.decrementAndGet();
            Log4jKit.clearMDC();
            httpServletRequest.setAttribute(EXIT_CALLED, (Object)Boolean.TRUE);
        }
    }

    private void setHeader(HttpServletResponse httpServletResponse, String headerName, String newValue) {
        if (newValue != null) {
            httpServletResponse.addHeader(headerName, newValue);
        }
    }

    private void recordLog4JInformation(HttpServletRequest httpServletRequest, String requestId, String atlassianSessionId) {
        Log4jKit.clearMDC();
        String url = AccessLogIPAddressUtil.getShortenedRequestUrl(httpServletRequest);
        String ipAddr = AccessLogIPAddressUtil.getRemoteAddr(httpServletRequest);
        Log4jKit.putToMDC(null, requestId, atlassianSessionId, url, ipAddr);
    }

    private void recordSessionInformation(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            httpServletRequest.setAttribute(JIRA_SESSION_LAST_ACCESSED_TIME, (Object)httpSession.getLastAccessedTime());
            httpServletRequest.setAttribute(JIRA_SESSION_MAX_INACTIVE_INTERVAL, (Object)httpSession.getMaxInactiveInterval());
        }
    }

    private String generateUniqueRequestId(long requestCount, long concurrentRequests) {
        long sinceEpoch = this.generateEpochValue();
        return String.valueOf(sinceEpoch) + "x" + requestCount + "x" + concurrentRequests;
    }

    private long generateEpochValue() {
        return new DateTime().getMinuteOfDay();
    }

    private void examineCookies(HttpServletRequest httpServletRequest) {
        Logger log = LoginLoggers.LOGIN_COOKIE_LOG;
        if (log.isDebugEnabled()) {
            String cookieHeader = httpServletRequest.getHeader("Cookie");
            Cookie[] allCookies = httpServletRequest.getCookies();
            if (cookieHeader == null) {
                log.debug((Object)"There is no cookie header.");
            } else {
                log.debug((Object)("The cookie header is '" + cookieHeader.length() + "' characters : '" + cookieHeader + "'."));
            }
            List<Cookie> jsessionCookies = this.getCookiesNamed("JSESSIONID", allCookies);
            if (jsessionCookies.size() == 0) {
                log.debug((Object)"The request has arrived WITHOUT a JSESSIONID cookie");
            }
            if (jsessionCookies.size() > 1) {
                log.debug((Object)("The request has arrived WITH MULTIPLE JSESSIONID cookies : " + jsessionCookies.size()));
            }
        }
    }

    private List<Cookie> getCookiesNamed(String targetCookieName, Cookie[] allCookies) {
        if (allCookies != null) {
            ArrayList namedCookies = Lists.newArrayListWithCapacity((int)allCookies.length);
            for (Cookie cookie : allCookies) {
                if (!targetCookieName.equals(cookie.getName())) continue;
                namedCookies.add(new Cookie(cookie.getName(), cookie.getValue()));
            }
            return namedCookies;
        }
        return Lists.newArrayList();
    }
}

