/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.annotations;

import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.web.filters.annotations.CheckResult;
import com.atlassian.sal.core.permission.AccessType;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;

class AllowlistChecker {
    private final Supplier<AnnotatedSecurityChecker> securityCheckerSupplier;

    AllowlistChecker(Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        this.securityCheckerSupplier = securityCheckerSupplier;
    }

    Optional<CheckResult> checkAllowlist(HttpServletRequest request) {
        String servletName;
        switch (servletName = request.getHttpServletMapping().getServletName()) {
            case "default": 
            case "jsp": {
                AccessType accessType = AccessType.UNRESTRICTED_ACCESS;
                boolean isAllowed = this.securityCheckerSupplier.get().isAllowedFor(accessType);
                return Optional.of(new CheckResult(servletName, accessType, isAllowed));
            }
        }
        return Optional.empty();
    }
}

