/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.annotations;

import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.servlet.ServletRequestUtil;
import com.atlassian.jira.web.filters.annotations.CheckResult;
import com.atlassian.sal.core.permission.AccessType;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class AnnotationChecker {
    private final Supplier<AnnotatedSecurityChecker> securityCheckerSupplier;

    AnnotationChecker(Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        this.securityCheckerSupplier = securityCheckerSupplier;
    }

    CheckResult checkAnnotations(HttpServletRequest request) {
        String servletName = request.getHttpServletMapping().getServletName();
        String servletClassName = request.getServletContext().getServletRegistration(servletName).getClassName();
        try {
            Class<?> servletClass = Class.forName(servletClassName);
            AccessType accessType = AccessType.getAccessType(servletClass, (String)ServletRequestUtil.getMethodName(request), (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
            boolean isAllowed = this.securityCheckerSupplier.get().isAllowedFor(accessType);
            return new CheckResult(servletName, servletClassName, accessType, isAllowed);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find class for servlet " + servletName, e);
        }
    }
}

