/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.annotations;

import com.atlassian.sal.core.permission.AccessType;
import java.util.Objects;
import javax.annotation.Nullable;

public class CheckResult {
    public static final String CHECK_TAG = "[SECURITY ANNOTATION CHECK]";
    private final String servletName;
    @Nullable
    private final String servletClassName;
    private final AccessType requiredAccessType;
    private final boolean isAllowed;
    private final boolean isNotFound;

    static CheckResult notFound(String servletName) {
        return new CheckResult(servletName);
    }

    private CheckResult(String servletName) {
        this.servletName = servletName;
        this.servletClassName = null;
        this.requiredAccessType = AccessType.EMPTY;
        this.isAllowed = false;
        this.isNotFound = true;
    }

    CheckResult(String servletName, AccessType requiredAccessType, boolean isAllowed) {
        this(servletName, null, requiredAccessType, isAllowed);
    }

    CheckResult(String servletName, @Nullable String servletClassName, AccessType requiredAccessType, boolean isAllowed) {
        this.servletName = servletName;
        this.servletClassName = servletClassName;
        this.requiredAccessType = requiredAccessType;
        this.isAllowed = isAllowed;
        this.isNotFound = false;
    }

    public AccessType getRequiredAccessType() {
        return this.requiredAccessType;
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public boolean isNotFound() {
        return this.isNotFound;
    }

    String getMessage() {
        if (this.isNotFound) {
            return "[SECURITY ANNOTATION CHECK] Servlet " + this.servletName + " not found";
        }
        if (this.getRequiredAccessType() == AccessType.EMPTY) {
            return "[SECURITY ANNOTATION CHECK] Servlet " + this.servletName + (String)(this.servletClassName != null ? ", class " + this.servletClassName : "") + " is not allowed for the current user. The servlet has no security annotation and so we use the default value. Redirecting to the login screen.";
        }
        return "[SECURITY ANNOTATION CHECK] Servlet " + this.servletName + (String)(this.servletClassName != null ? ", class " + this.servletClassName : "") + " is " + (this.isAllowed() ? "" : "not ") + "allowed for the current user. The servlet has accessType=" + this.getRequiredAccessType();
    }

    public String toString() {
        return "CheckResult{servletName='" + this.servletName + "', servletClassName='" + this.servletClassName + "', requiredAccessType=" + this.requiredAccessType + ", isAllowed=" + this.isAllowed + ", isNotFound=" + this.isNotFound + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckResult that = (CheckResult)o;
        return this.isAllowed == that.isAllowed && this.isNotFound == that.isNotFound && Objects.equals(this.servletName, that.servletName) && Objects.equals(this.servletClassName, that.servletClassName) && this.requiredAccessType == that.requiredAccessType;
    }

    public int hashCode() {
        return Objects.hash(this.servletName, this.servletClassName, this.requiredAccessType, this.isAllowed, this.isNotFound);
    }
}

