/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.annotations;

import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.filters.annotations.CheckResult;
import com.atlassian.sal.core.permission.AccessType;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JspChecker {
    private static final Logger log = LoggerFactory.getLogger(JspChecker.class);
    static final Map<String, AccessType> JSP_ACCESS_TYPES = Map.ofEntries(Map.entry("secure.admin.default", AccessType.ADMIN_ONLY), Map.entry("secure.errors", AccessType.UNRESTRICTED_ACCESS), Map.entry("default", AccessType.UNRESTRICTED_ACCESS), Map.entry("login", AccessType.UNRESTRICTED_ACCESS), Map.entry("logout", AccessType.UNRESTRICTED_ACCESS), Map.entry("alreadyloggedout", AccessType.UNRESTRICTED_ACCESS), Map.entry("logoutconfirm", AccessType.UNRESTRICTED_ACCESS), Map.entry("secure.admin.debug.logMessage", AccessType.ADMIN_ONLY), Map.entry("secure.views.projectnotfound", AccessType.ANONYMOUS_SITE_ACCESS), Map.entry("secure.views.searchrequesterror", AccessType.ANONYMOUS_SITE_ACCESS), Map.entry("secure.views.securitybreach", AccessType.ANONYMOUS_SITE_ACCESS), Map.entry("views.setup_002dadmin_002daccount", AccessType.UNRESTRICTED_ACCESS), Map.entry("includes.loginpage", AccessType.UNRESTRICTED_ACCESS), Map.entry("includes.loginform", AccessType.UNRESTRICTED_ACCESS), Map.entry("osd", AccessType.UNRESTRICTED_ACCESS), Map.entry("views.setup_002dmail_002dnotifications", AccessType.UNRESTRICTED_ACCESS), Map.entry("views.setup_002dimport", AccessType.UNRESTRICTED_ACCESS), Map.entry("views.setup_002dapplication_002dproperties", AccessType.UNRESTRICTED_ACCESS));
    private final Supplier<AnnotatedSecurityChecker> securityCheckerSupplier;

    JspChecker(Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        this.securityCheckerSupplier = securityCheckerSupplier;
    }

    Optional<CheckResult> checkJsps(HttpServletRequest request) {
        String servletName = request.getHttpServletMapping().getServletName();
        boolean isJsp = JspChecker.isJsp(servletName);
        Object viewRequestedByActionValue = request.getAttribute("view.requested.by.action");
        if (!isJsp) {
            if (viewRequestedByActionValue != null) {
                log.debug("[SECURITY ANNOTATION CHECK] {}={}, but servlet '{}' is not a JSP", new Object[]{"view.requested.by.action", viewRequestedByActionValue, servletName});
            }
            return Optional.empty();
        }
        return JspChecker.getCheckResultIfViewRequestedByAction(viewRequestedByActionValue, servletName).or(() -> this.getCheckResultBasedOnJspAccessTypesList(servletName));
    }

    private static Optional<CheckResult> getCheckResultIfViewRequestedByAction(Object viewRequestedByActionValue, String servletName) {
        if (viewRequestedByActionValue != null) {
            Collection mappings = ((ServletRegistration)ServletContextProvider.getServletContext().getServletRegistrations().get(servletName)).getMappings();
            if (mappings.contains(viewRequestedByActionValue)) {
                log.trace("[SECURITY ANNOTATION CHECK] {}={} and servlet='{}' mappings={} match", new Object[]{"view.requested.by.action", viewRequestedByActionValue, servletName, mappings});
                return Optional.of(new CheckResult(servletName, AccessType.UNRESTRICTED_ACCESS, true));
            }
            log.debug("[SECURITY ANNOTATION CHECK] {}={}, but servlet='{}' mappings={} do not match", new Object[]{"view.requested.by.action", viewRequestedByActionValue, servletName, mappings});
        }
        return Optional.empty();
    }

    private Optional<CheckResult> getCheckResultBasedOnJspAccessTypesList(String servletName) {
        AccessType accessType = JSP_ACCESS_TYPES.get(JspChecker.getJspName(servletName));
        if (accessType != null) {
            log.trace("[SECURITY ANNOTATION CHECK] Servlet='{}' matched allowlist", (Object)servletName);
            boolean isAllowed = this.securityCheckerSupplier.get().isAllowedFor(accessType);
            return Optional.of(new CheckResult(servletName, accessType, isAllowed));
        }
        log.debug("[SECURITY ANNOTATION CHECK] Servlet='{}' did not match any allowlistEntry", (Object)servletName);
        return Optional.of(CheckResult.notFound(servletName));
    }

    private static boolean isJsp(String servletName) {
        return servletName.startsWith("jsp.") && servletName.endsWith("_jsp");
    }

    private static String getJspName(String servletName) {
        Preconditions.checkArgument((boolean)JspChecker.isJsp(servletName));
        return servletName.substring("jsp.".length(), servletName.length() - "_jsp".length());
    }
}

