/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.annotations;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.annotated.AnnotatedSecurityEnabledCheck;
import com.atlassian.jira.security.annotated.SecureDefaultsStats;
import com.atlassian.jira.servlet.ServletRequestUtil;
import com.atlassian.jira.web.filters.annotations.AllowlistChecker;
import com.atlassian.jira.web.filters.annotations.AnnotationChecker;
import com.atlassian.jira.web.filters.annotations.CheckResult;
import com.atlassian.jira.web.filters.annotations.JspChecker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ServletSecurityAnnotationsFilter
extends AbstractHttpFilter {
    private static final Logger log = LoggerFactory.getLogger(ServletSecurityAnnotationsFilter.class);
    private final AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck;
    private final AllowlistChecker allowlistChecker;
    private final JspChecker jspChecker;
    private final AnnotationChecker annotationChecker;

    public ServletSecurityAnnotationsFilter() {
        this(new AnnotatedSecurityEnabledCheck(), new AllowlistChecker(ServletRequestUtil::getSecurityChecker), new JspChecker(ServletRequestUtil::getSecurityChecker), new AnnotationChecker(ServletRequestUtil::getSecurityChecker));
    }

    @VisibleForTesting
    ServletSecurityAnnotationsFilter(AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, AllowlistChecker allowlistChecker, JspChecker jspChecker, AnnotationChecker annotationChecker) {
        this.annotatedSecurityEnabledCheck = annotatedSecurityEnabledCheck;
        this.allowlistChecker = allowlistChecker;
        this.jspChecker = jspChecker;
        this.annotationChecker = annotationChecker;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.annotatedSecurityEnabledCheck.isAnnotatedSecurityDisabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Optional<CheckResult> allowlistCheckResult = this.allowlistChecker.checkAllowlist(request);
        CheckResult checkResult = allowlistCheckResult.orElseGet(() -> this.jspChecker.checkJsps(request).orElseGet(() -> this.annotationChecker.checkAnnotations(request)));
        if (checkResult.isNotFound()) {
            response.sendError(404);
        } else if (checkResult.isAllowed()) {
            if (allowlistCheckResult.isEmpty()) {
                ServletRequestUtil.clearRedirectAttributes(request);
            }
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.servletAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("{}. Redirecting to login screen.", (Object)checkResult.getMessage());
            }
            ServletRequestUtil.redirectToLoginScreen(request, response, checkResult.getRequiredAccessType());
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.servletNotAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
        }
    }
}

