/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.gzip;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.gzipfilter.GzipFilter;
import com.atlassian.gzipfilter.integration.GzipFilterIntegration;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import javax.servlet.http.HttpServletRequest;

@UnrestrictedAccess
public class JiraGzipFilter
extends GzipFilter {
    private static final String ALREADY_FILTERED = GzipFilter.class.getName() + "_already_filtered";

    public JiraGzipFilter() {
        super((GzipFilterIntegration)new JiraGzipFilterIntegration());
    }

    private static class JiraGzipFilterIntegration
    implements GzipFilterIntegration {
        private JiraGzipFilterIntegration() {
        }

        public boolean useGzip() {
            return ComponentAccessor.getComponentSafely(ApplicationProperties.class).map(applicationProperties -> {
                try {
                    return applicationProperties.getOption("jira.option.web.usegzip");
                }
                catch (RuntimeException e) {
                    return false;
                }
            }).orElse(false);
        }

        public String getResponseEncoding(HttpServletRequest httpServletRequest) {
            return ComponentAccessor.getComponentSafely(ApplicationProperties.class).map(ApplicationProperties::getEncoding).orElse("UTF-8");
        }
    }
}

