/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.johnson;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.web.filters.johnson.JiraJohnsonFilter;
import com.atlassian.jira.web.filters.johnson.JohnsonInterceptor;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.filters.Johnson503Filter;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class JiraJohnson503Filter
extends Johnson503Filter {
    private static final String JIRA_JOHNSON_503_ALREADY_FILTERED = JiraJohnson503Filter.class.getName() + "_already_filtered";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isNotAlreadyFiltered(servletRequest)) {
            servletRequest.setAttribute(JIRA_JOHNSON_503_ALREADY_FILTERED, (Object)Boolean.TRUE);
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            JohnsonEventContainer johnsonContainer = this.getJohnsonContainer();
            JohnsonInterceptor johnsonInterceptor = JohnsonInterceptor.getInstance(johnsonContainer, JiraJohnson503Filter.getServletPath((HttpServletRequest)request), this.config.getSetupConfig(), request, x$0 -> this.ignoreURI((String)x$0));
            Optional<JohnsonInterceptor.Reason> intercepted = johnsonInterceptor.intercept();
            if (intercepted.isPresent()) {
                switch (intercepted.get()) {
                    case JOHNSON_EVENT: {
                        this.handleError(johnsonContainer, request, response);
                    }
                    case STARTUP_PAGE: {
                        ServiceUnavailableResponder.respondWithEmpty503(servletResponse);
                        break;
                    }
                    case NOT_SETUP: {
                        this.handleNotSetup(request, response);
                    }
                }
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isNotAlreadyFiltered(ServletRequest servletRequest) {
        return servletRequest.getAttribute(JiraJohnsonFilter.JOHNSON_ALREADY_FILTERED) == null && servletRequest.getAttribute(JIRA_JOHNSON_503_ALREADY_FILTERED) == null;
    }

    private JohnsonEventContainer getJohnsonContainer() {
        return Johnson.getEventContainer();
    }
}

