/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.mau;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.web.filters.mau.AbstractMauRequestTaggingFilter;
import io.atlassian.fugue.Either;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class MauRequestTaggingFilter
extends AbstractMauRequestTaggingFilter {
    private FilterConfig filterConfig;

    @Override
    public void tagRequest(MauEventService mauEventService, HttpServletRequest request) {
        MauApplicationKey mauApplicationKey = this.determineMauApplicationKey(this.filterConfig.getInitParameter("mauApplicationKey"));
        if (mauApplicationKey != null) {
            mauEventService.setApplicationForThread(mauApplicationKey);
        }
    }

    private MauApplicationKey determineMauApplicationKey(String mauKey) {
        if (StringUtils.isEmpty((CharSequence)mauKey)) {
            return null;
        }
        ApplicationKey applicationKey = this.toApplicationKey(mauKey);
        if (applicationKey != null) {
            return MauApplicationKey.forApplication((ApplicationKey)applicationKey);
        }
        if (MauApplicationKey.family().getKey().equals(mauKey)) {
            return MauApplicationKey.family();
        }
        return null;
    }

    private ApplicationKey toApplicationKey(String key) {
        ApplicationKey applicationKey;
        Either apply = (Either)ApplicationKeys.TO_APPLICATION_KEY.apply((Object)key);
        if (apply.isRight() && (ApplicationKeys.CORE.equals((Object)(applicationKey = (ApplicationKey)apply.right().get())) || ApplicationKeys.SERVICE_DESK.equals((Object)applicationKey) || ApplicationKeys.SOFTWARE.equals((Object)applicationKey))) {
            return applicationKey;
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }
}

